/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.model.managers.constraints.global;

import choco.cp.model.managers.MixedConstraintManager;
import choco.cp.solver.CPSolver;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.model.variables.scheduling.TaskVariable;
import choco.kernel.solver.Solver;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.integer.IntExp;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.scheduling.TaskVar;
import java.util.List;

public abstract class AbstractPrecedenceManager
extends MixedConstraintManager {
    protected abstract SConstraint makeIntConstraintB0(CPSolver var1, IntDomainVar var2, int var3, IntDomainVar var4, int var5);

    protected SConstraint makeIntConstraintB1(CPSolver s, IntDomainVar x1, int k1, IntDomainVar x2, int k2) {
        return s.leq(s.plus((IntExp)x1, k1), (IntExp)x2);
    }

    protected abstract SConstraint makeIntConstraint(CPSolver var1, IntDomainVar var2, int var3, IntDomainVar var4, int var5, IntDomainVar var6);

    protected abstract SConstraint makeTaskConstraintB0(CPSolver var1, TaskVar var2, int var3, TaskVar var4, int var5);

    protected SConstraint makeTaskConstraintB1(CPSolver s, TaskVar t1, int k1, TaskVar t2, int k2) {
        return s.preceding(t1, k1, t2);
    }

    protected abstract SConstraint makeTaskConstraint(CPSolver var1, TaskVar var2, int var3, TaskVar var4, int var5, IntDomainVar var6);

    protected final int getConstantValue(Solver s, Variable var) {
        IntDomainVar v = s.getVar((IntegerVariable)var);
        if (v.isInstantiated()) {
            return v.getVal();
        }
        throw new SolverException(var + " should be constant");
    }

    public final SConstraint makeConstraint(Solver solver, Variable[] variables, Object parameters, List<String> options) {
        if (solver instanceof CPSolver) {
            CPSolver s = (CPSolver)solver;
            int k1 = this.getConstantValue(s, variables[1]);
            int k2 = this.getConstantValue(s, variables[3]);
            IntDomainVar dir = solver.getVar((IntegerVariable)variables[4]);
            if (parameters == Boolean.TRUE) {
                TaskVar t1 = solver.getVar((TaskVariable)variables[0]);
                TaskVar t2 = solver.getVar((TaskVariable)variables[2]);
                if (dir.isInstantiatedTo(0)) {
                    return this.makeTaskConstraintB0(s, t1, k1, t2, k2);
                }
                if (dir.isInstantiatedTo(1)) {
                    return this.makeTaskConstraintB1(s, t1, k1, t2, k2);
                }
                return this.makeTaskConstraint(s, t1, k1, t2, k2, dir);
            }
            if (parameters == Boolean.FALSE) {
                IntDomainVar x1 = solver.getVar((IntegerVariable)variables[0]);
                IntDomainVar x2 = solver.getVar((IntegerVariable)variables[2]);
                if (dir.isInstantiatedTo(0)) {
                    return this.makeIntConstraintB0(s, x1, k1, x2, k2);
                }
                if (dir.isInstantiatedTo(1)) {
                    return this.makeIntConstraintB1(s, x1, k1, x2, k2);
                }
                return this.makeIntConstraint(s, x1, k1, x2, k2, dir);
            }
            LOGGER.severe("unknown constraint parameters: " + parameters);
        }
        return AbstractPrecedenceManager.fail("Precedence (Implied|Reified|Disjoint)");
    }

    @Override
    public int[] getFavoriteDomains(List<String> options) {
        return AbstractPrecedenceManager.getBCFavoriteIntDomains();
    }
}

