/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp.xgboost;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.dmg.pmml.DataType;
import org.dmg.pmml.VerificationField;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.rexp.RExpEncoder;
import org.jpmml.rexp.RGenericVector;
import org.jpmml.rexp.xgboost.XGBoostConverter;

public class XGBoost3Converter
extends XGBoostConverter {
    public XGBoost3Converter(RGenericVector booster) {
        super(booster);
    }

    @Override
    protected Map<VerificationField, List<?>> encodeActiveValues(RGenericVector dataFrame) {
        return XGBoost3Converter.encodeVerificationData((RGenericVector)dataFrame);
    }

    @Override
    protected String getJsonPath() {
        return "$";
    }

    @Override
    protected List<Feature> aggregateFeatures(List<? extends Feature> features, RExpEncoder encoder) {
        ArrayList<Feature> result = new ArrayList<Feature>();
        int i = 0;
        int max = features.size();
        while (i < max) {
            Feature feature = features.get(i);
            if (feature instanceof BinaryFeature) {
                BinaryFeature nextBinaryFeature;
                String nextName;
                Feature nextFeature;
                BinaryFeature binaryFeature = (BinaryFeature)feature;
                String name = binaryFeature.getName();
                DataType dataType = binaryFeature.getDataType();
                ArrayList<Object> values = new ArrayList<Object>();
                values.add(binaryFeature.getValue());
                ++i;
                while (i < max && (nextFeature = features.get(i)) instanceof BinaryFeature && Objects.equals(name, nextName = (nextBinaryFeature = (BinaryFeature)nextFeature).getName())) {
                    values.add(nextBinaryFeature.getValue());
                    ++i;
                }
                CategoricalFeature categoricalFeature = new CategoricalFeature((PMMLEncoder)encoder, name, dataType, values);
                result.add((Feature)categoricalFeature);
                continue;
            }
            result.add(feature);
            ++i;
        }
        return result;
    }
}

