/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.lang.reflect.Field;
import java.util.List;
import org.dmg.pmml.PMMLObject;
import org.jpmml.model.annotations.CollectionElementType;

public class XPathUtil {
    private XPathUtil() {
    }

    public static String formatElement(Class<? extends PMMLObject> elementClazz) {
        return XPathUtil.getElementName(elementClazz);
    }

    public static String formatElementOrAttribute(Field field) {
        return XPathUtil.formatElementOrAttribute(field.getDeclaringClass(), field);
    }

    public static String formatElementOrAttribute(Class<? extends PMMLObject> elementClazz, Field field) {
        XmlElement element = field.getAnnotation(XmlElement.class);
        XmlElements elements = field.getAnnotation(XmlElements.class);
        XmlAttribute attribute = field.getAnnotation(XmlAttribute.class);
        if (element != null) {
            Class<?> childElementClazz = XPathUtil.getElementType(field);
            try {
                return XPathUtil.getElementName(elementClazz) + "/" + XPathUtil.getElementName(childElementClazz);
            }
            catch (IllegalArgumentException iae) {
                return XPathUtil.getElementName(elementClazz) + "/" + element.name();
            }
        }
        if (elements != null) {
            Class<?> childElementClazz = XPathUtil.getElementType(field);
            return XPathUtil.getElementName(elementClazz) + "/<" + childElementClazz.getSimpleName() + ">";
        }
        if (attribute != null) {
            return XPathUtil.getElementName(elementClazz) + "@" + attribute.name();
        }
        throw new IllegalArgumentException();
    }

    public static String formatAttribute(Field field, Object value) {
        return XPathUtil.formatAttribute(field.getDeclaringClass(), field, value);
    }

    public static String formatAttribute(Class<? extends PMMLObject> elementClazz, Field field, Object value) {
        XmlAttribute attribute = field.getAnnotation(XmlAttribute.class);
        if (attribute != null) {
            return XPathUtil.formatElementOrAttribute(elementClazz, field) + (String)(value != null ? "=" + String.valueOf(value) : "");
        }
        throw new IllegalArgumentException();
    }

    public static Class<?> getElementType(Field field) {
        Class<?> elementClazz = field.getType();
        if (List.class.isAssignableFrom(elementClazz)) {
            CollectionElementType collectionElementType = field.getAnnotation(CollectionElementType.class);
            if (collectionElementType == null) {
                throw new IllegalArgumentException();
            }
            elementClazz = collectionElementType.value();
        }
        return elementClazz;
    }

    private static String getElementName(Class<?> clazz) {
        while (clazz != null) {
            XmlRootElement rootElement = clazz.getAnnotation(XmlRootElement.class);
            if (rootElement != null) {
                return rootElement.name();
            }
            clazz = clazz.getSuperclass();
        }
        throw new IllegalArgumentException();
    }
}

