/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.graphs;

import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetType;

public interface IGraph {
    public ISet getNodes();

    public boolean addNode(int var1);

    public boolean removeNode(int var1);

    public boolean addEdge(int var1, int var2);

    public boolean removeEdge(int var1, int var2);

    public int getNbMaxNodes();

    public SetType getNodeSetType();

    public SetType getEdgeSetType();

    public ISet getSuccessorsOf(int var1);

    public ISet getPredecessorsOf(int var1);

    default public boolean containsEdge(int x, int y) {
        return this.getSuccessorsOf(x).contains(y);
    }

    default public boolean containsNode(int x) {
        return this.getNodes().contains(x);
    }

    public boolean isDirected();

    default public String graphVizExport() {
        int i;
        boolean directed = this.isDirected();
        String arc = directed ? " -> " : " -- ";
        StringBuilder sb = new StringBuilder();
        sb.append(directed ? "digraph " : "graph ").append("G{\n");
        ISetIterator iSetIterator = this.getNodes().iterator();
        while (iSetIterator.hasNext()) {
            i = (Integer)iSetIterator.next();
            sb.append(i + " ");
        }
        sb.append(";\n");
        iSetIterator = this.getNodes().iterator();
        while (iSetIterator.hasNext()) {
            i = (Integer)iSetIterator.next();
            ISetIterator iSetIterator2 = this.getSuccessorsOf(i).iterator();
            while (iSetIterator2.hasNext()) {
                int j = (Integer)iSetIterator2.next();
                if (!directed && i >= j) continue;
                sb.append(i + arc + j + " ;\n");
            }
        }
        sb.append("}");
        return sb.toString();
    }
}

