/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core.tests;

import java.util.Iterator;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.dstats.ContinuousDistribution;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.stats.TestType;
import jdplus.toolkit.base.api.timeseries.regression.PeriodicContrasts;
import jdplus.toolkit.base.api.timeseries.regression.PeriodicDummies;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.analysis.TrigonometricSeries;
import jdplus.toolkit.base.core.data.analysis.WindowFunction;
import jdplus.toolkit.base.core.dstats.F;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.LowerTriangularMatrix;
import jdplus.toolkit.base.core.math.matrices.QuadraticForm;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.modelling.regression.PeriodicContrastsFactory;
import jdplus.toolkit.base.core.modelling.regression.PeriodicDummiesFactory;
import jdplus.toolkit.base.core.stats.RobustCovarianceComputer;
import jdplus.toolkit.base.core.stats.linearmodel.LeastSquaresResults;
import jdplus.toolkit.base.core.stats.linearmodel.LinearModel;
import jdplus.toolkit.base.core.stats.linearmodel.Ols;
import jdplus.toolkit.base.core.stats.tests.TestsUtility;

public class CanovaHansen {
    private final Variables type;
    private final FastMatrix x;
    private final FastMatrix xe;
    private final FastMatrix cxe;
    private final FastMatrix phi;
    private final DoubleSeq c;
    private final DoubleSeq u;
    private final int nx;
    private final int ns;

    public static Builder test(DoubleSeq s) {
        return new Builder(s);
    }

    public DoubleSeq getE() {
        return this.u;
    }

    private CanovaHansen(Variables type, LinearModel lm, int ns, WindowFunction winFunction, int truncationLag) {
        this.ns = ns;
        this.type = type;
        this.x = lm.variables();
        this.nx = this.x.getColumnsCount();
        LeastSquaresResults olsResults = Ols.compute((LinearModel)lm);
        this.c = olsResults.getCoefficients();
        this.u = lm.calcResiduals(this.c);
        this.xe = this.x.deepClone();
        this.xe.applyByColumns(col -> col.apply(this.u, (a, b) -> a * b));
        this.phi = RobustCovarianceComputer.covariance((FastMatrix)this.xe, (WindowFunction)winFunction, (int)truncationLag);
        this.cxe = this.xe.deepClone();
        this.cxe.applyByColumns(col -> col.cumul());
    }

    public double test(int var) {
        int dx = this.nx - this.ns;
        int dvar = var + dx;
        return CanovaHansen.computeStat(this.phi.get(dvar, dvar), this.cxe.column(dvar));
    }

    public double test(int var, int nvars) {
        int dx = this.nx - this.ns;
        int dvar = var + dx;
        return CanovaHansen.computeStat(this.phi.extract(dvar, nvars, dvar, nvars), this.cxe.extract(0, this.cxe.getRowsCount(), dvar, nvars));
    }

    public double testAll() {
        return this.test(0, this.ns);
    }

    public double testDerived() {
        if (this.type != Variables.Contrast) {
            return Double.NaN;
        }
        int dx = this.nx - this.ns;
        FastMatrix tphi = this.phi.extract(dx, this.ns, dx, this.ns);
        DataBlock tc = DataBlock.of((DoubleSeq)this.c.extract(dx, this.ns));
        double v = QuadraticForm.apply((FastMatrix)tphi, (DataBlock)tc);
        FastMatrix ce = this.cxe.extract(0, this.cxe.getRowsCount(), dx, this.ns);
        DataBlock E = DataBlock.make((int)ce.getRowsCount());
        E.product((Iterator)ce.rowsIterator(), tc);
        return CanovaHansen.computeStat(v, E);
    }

    public StatisticalTest seasonalityTest() {
        int dx = this.nx - this.ns;
        FastMatrix rcov = this.robustCovarianceOfCoefficients().extract(dx, this.ns, dx, this.ns);
        SymmetricMatrix.lcholesky((FastMatrix)rcov);
        LowerTriangularMatrix.toLower((FastMatrix)rcov);
        DataBlock b = DataBlock.of((DoubleSeq)this.c.extract(dx, this.ns));
        LowerTriangularMatrix.solveLx((FastMatrix)rcov, (DataBlock)b);
        double fval = b.ssq() / (double)this.ns;
        F f = new F((double)this.ns, (double)(this.x.getRowsCount() - this.c.length()));
        return TestsUtility.testOf((double)fval, (ContinuousDistribution)f, (TestType)TestType.Upper);
    }

    private static double computeStat(FastMatrix O, FastMatrix cx) {
        int n = cx.getRowsCount();
        int ncx = cx.getColumnsCount();
        FastMatrix FF = FastMatrix.square((int)ncx);
        for (int i = 0; i < n; ++i) {
            FF.addXaXt(1.0, cx.row(i));
        }
        FastMatrix sig = O.deepClone();
        SymmetricMatrix.lcholesky((FastMatrix)sig);
        LowerTriangularMatrix.solveLX((FastMatrix)sig, (FastMatrix)FF);
        LowerTriangularMatrix.solveLtX((FastMatrix)sig, (FastMatrix)FF);
        double tr = FF.diagonal().sum();
        return tr / (double)(n * n);
    }

    private static double computeStat(double O, DataBlock cx) {
        int n = cx.length();
        double F2 = cx.ssq();
        double tr = F2 / O;
        return tr / (double)(n * n);
    }

    private FastMatrix robustCovarianceOfCoefficients() {
        FastMatrix Lo = this.phi.deepClone();
        SymmetricMatrix.lcholesky((FastMatrix)Lo);
        LowerTriangularMatrix.toLower((FastMatrix)Lo);
        FastMatrix Lx = SymmetricMatrix.XtX((FastMatrix)this.x);
        SymmetricMatrix.lcholesky((FastMatrix)Lx);
        LowerTriangularMatrix.solveLX((FastMatrix)Lx, (FastMatrix)Lo);
        LowerTriangularMatrix.solveLtX((FastMatrix)Lx, (FastMatrix)Lo);
        FastMatrix XXt = SymmetricMatrix.XXt((FastMatrix)Lo);
        XXt.mul((double)this.xe.getRowsCount());
        return XXt;
    }

    public static class Builder {
        private final DoubleSeq s;
        private double period;
        private boolean lag1 = true;
        private Variables type = Variables.Dummy;
        private WindowFunction winFunction = WindowFunction.Bartlett;
        private int truncationLag = 12;
        private int startPosition;
        private int nh;

        private Builder(DoubleSeq s) {
            this.s = s;
        }

        public Builder dummies(int period) {
            this.type = Variables.Dummy;
            this.period = period;
            return this;
        }

        public Builder contrasts(int period) {
            this.type = Variables.Contrast;
            this.period = period;
            return this;
        }

        public Builder trigonometric(int period) {
            this.type = Variables.Trigonometric;
            this.period = period;
            return this;
        }

        public Builder specific(double period, int nharmonics) {
            this.type = Variables.UserDefined;
            this.period = period;
            this.nh = nharmonics;
            return this;
        }

        public Builder lag1(boolean lag1) {
            this.lag1 = lag1;
            return this;
        }

        public Builder truncationLag(int truncationLag) {
            this.truncationLag = truncationLag;
            return this;
        }

        public Builder windowFunction(WindowFunction winFunction) {
            this.winFunction = winFunction;
            return this;
        }

        public Builder startPosition(int startPosition) {
            this.startPosition = startPosition;
            return this;
        }

        public CanovaHansen build() {
            FastMatrix x = this.sx();
            LinearModel lm = this.buildModel(x);
            return new CanovaHansen(this.type, lm, x.getColumnsCount(), this.winFunction, this.truncationLag);
        }

        private FastMatrix sx() {
            int len = this.s.length();
            int pos = this.startPosition;
            if (this.lag1) {
                ++pos;
                --len;
            }
            switch (this.type.ordinal()) {
                case 0: {
                    PeriodicDummies vars = new PeriodicDummies((int)this.period);
                    return PeriodicDummiesFactory.matrix((PeriodicDummies)vars, (int)len, (int)pos);
                }
                case 1: {
                    PeriodicContrasts vars = new PeriodicContrasts((int)this.period);
                    return PeriodicContrastsFactory.matrix((PeriodicContrasts)vars, (int)len, (int)pos);
                }
                case 2: {
                    TrigonometricSeries vars = TrigonometricSeries.regular((int)((int)this.period));
                    return vars.matrix(len, pos);
                }
            }
            TrigonometricSeries vars = TrigonometricSeries.all((double)this.period, (int)this.nh);
            return vars.matrix(len, pos);
        }

        private LinearModel buildModel(FastMatrix sx) {
            LinearModel.Builder builder = LinearModel.builder();
            if (this.lag1) {
                builder.y(this.s.drop(1, 0)).addX(this.s.drop(0, 1));
            } else {
                builder.y(this.s);
            }
            switch (this.type.ordinal()) {
                case 0: {
                    builder.addX((Matrix)sx);
                    break;
                }
                case 2: {
                    builder.addX((Matrix)sx).meanCorrection(true);
                    break;
                }
                case 1: {
                    builder.addX((Matrix)sx).meanCorrection(true);
                    break;
                }
                default: {
                    builder.addX((Matrix)sx).meanCorrection(true);
                }
            }
            return builder.build();
        }
    }

    public static enum Variables {
        Dummy,
        Contrast,
        Trigonometric,
        UserDefined;

    }
}

