/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regsarima.ami;

import java.util.ArrayList;
import java.util.Arrays;
import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.arima.SarmaOrders;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.Doubles;
import jdplus.toolkit.base.core.arima.estimation.IArimaMapping;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.modelling.regression.AdditiveOutlierFactory;
import jdplus.toolkit.base.core.modelling.regression.IOutlierFactory;
import jdplus.toolkit.base.core.modelling.regression.LevelShiftFactory;
import jdplus.toolkit.base.core.modelling.regression.TransitoryChangeFactory;
import jdplus.toolkit.base.core.regarima.IRegArimaComputer;
import jdplus.toolkit.base.core.regarima.RegArimaEstimation;
import jdplus.toolkit.base.core.regarima.RegArimaModel;
import jdplus.toolkit.base.core.regarima.RegArmaModel;
import jdplus.toolkit.base.core.regarima.ami.GenericOutliersDetection;
import jdplus.toolkit.base.core.regarima.estimation.ConcentratedLikelihoodComputer;
import jdplus.toolkit.base.core.regarima.outlier.FastOutlierDetector;
import jdplus.toolkit.base.core.regarima.outlier.SingleOutlierDetector;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.toolkit.base.core.sarima.estimation.HannanRissanen;
import jdplus.toolkit.base.core.sarima.estimation.SarimaMapping;
import jdplus.toolkit.base.core.stats.likelihood.ConcentratedLikelihoodWithMissing;
import jdplus.toolkit.base.core.stats.linearmodel.LeastSquaresResults;
import jdplus.toolkit.base.core.stats.linearmodel.LinearModel;
import jdplus.toolkit.base.core.stats.linearmodel.Ols;

public class FastOutliersDetector
implements GenericOutliersDetection<SarimaModel> {
    static int DEF_MAXROUND = 100;
    static int DEF_MAXOUTLIERS = 50;
    private final int maxRound;
    private final int maxOutliers;
    private final ArrayList<int[]> outliers = new ArrayList();
    private final SingleOutlierDetector sod;
    private final IRegArimaComputer<SarimaModel> processor;
    private final double cv;
    private final boolean mvx;
    private RegArimaModel<SarimaModel> regarima;
    private double[] tstats;
    private int round;
    private boolean rflag;
    private boolean backwardStep;
    private boolean exit;
    private boolean estimationStep;
    private int[] lastremoved;
    private DoubleSeq coeff;
    private DoubleSeq res;

    public static SingleOutlierDetector<SarimaModel> defaultOutlierDetector() {
        FastOutlierDetector<SarimaModel> detector = new FastOutlierDetector<SarimaModel>(null);
        detector.setOutlierFactories(AdditiveOutlierFactory.FACTORY, LevelShiftFactory.FACTORY_ZEROSTARTED, new TransitoryChangeFactory(0.7));
        return detector;
    }

    public static Builder builder() {
        return new Builder();
    }

    private FastOutliersDetector(SingleOutlierDetector sod, IRegArimaComputer<SarimaModel> processor, int maxOutliers, int maxRound, double cv, boolean mvx) {
        this.sod = sod;
        this.processor = processor;
        this.maxOutliers = maxOutliers;
        this.maxRound = maxRound;
        this.mvx = mvx;
        this.cv = cv;
    }

    @Override
    public void setBounds(int start, int end) {
        this.sod.setBounds(start, end);
    }

    @Override
    public void prepare(int n) {
        this.sod.prepare(n);
    }

    @Override
    public void exclude(int pos, int type) {
        this.sod.exclude(pos, type);
    }

    @Override
    public int[][] getOutliers() {
        return (int[][])this.outliers.toArray(x$0 -> new int[x$0][]);
    }

    public IOutlierFactory getFactory(int i) {
        return this.sod.getOutlierFactory(i);
    }

    public String[] outlierTypes() {
        IOutlierFactory[] factories = this.sod.getOutliersFactories();
        String[] types = new String[factories.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = factories[i].getCode();
        }
        return types;
    }

    public RegArimaModel<SarimaModel> getRegArima() {
        return this.regarima;
    }

    @Override
    public boolean process(RegArimaModel<SarimaModel> initialModel, IArimaMapping<SarimaModel> mapping) {
        this.clear();
        int n = initialModel.getY().length();
        this.regarima = initialModel;
        try {
            do {
                if (!this.estimateModel(mapping)) {
                    return false;
                }
                boolean search = true;
                if (this.backwardStep) {
                    search = this.verifyModel();
                    if (this.exit) break;
                }
                if (!search) continue;
                if (!this.sod.process(this.regarima)) break;
                ++this.round;
                double max = this.sod.getMaxTStat();
                if (Math.abs(max) < this.cv) break;
                int type = this.sod.getMaxOutlierType();
                int pos = this.sod.getMaxOutlierPosition();
                this.addOutlier(pos, type, this.sod.coefficient(pos, type));
                if (this.outliers.size() == this.maxOutliers) break;
            } while (this.round < this.maxRound);
            if (this.exit || this.round == this.maxRound || this.outliers.size() == this.maxOutliers) {
                this.estimateModel(mapping);
            }
            this.estimationStep = false;
            while (!this.verifyModel()) {
                this.estimateModel(mapping);
            }
            return true;
        }
        catch (RuntimeException err) {
            return false;
        }
    }

    private boolean estimateModel(IArimaMapping<SarimaModel> mapping) {
        SarimaModel sarima = this.regarima.arima();
        SarimaOrders spec = sarima.orders();
        RegArmaModel<SarimaModel> dm = this.regarima.differencedModel();
        LinearModel lm = dm.asLinearModel();
        if (this.rflag) {
            if (lm.getVariablesCount() > 0) {
                LeastSquaresResults lsr = Ols.compute(lm);
                if (lsr == null) {
                    return false;
                }
                this.res = lm.calcResiduals(lsr.getCoefficients());
            } else {
                this.res = lm.getY();
            }
        } else {
            this.res = this.coeff != null ? lm.calcResiduals(this.coeff) : lm.getY();
        }
        boolean stable = true;
        this.rflag = false;
        if (this.estimationStep) {
            HannanRissanen hr;
            SarmaOrders dspec = spec.doStationary();
            if (spec.getParametersCount() != 0 && (hr = HannanRissanen.builder().build()).process(this.res, dspec)) {
                SarimaModel hrmodel = hr.getModel();
                SarimaModel stmodel = SarimaMapping.stabilize(hrmodel);
                boolean bl = stable = stmodel == hrmodel;
                if (stable || this.mvx || this.round == 0) {
                    this.regarima = RegArimaModel.of(this.regarima, SarimaModel.builder(spec).parameters(stmodel.parameters()).build());
                } else {
                    this.rflag = true;
                    stable = true;
                }
            }
            if (this.mvx || !stable) {
                return this.optimizeModel(mapping);
            }
        }
        if (lm.getVariablesCount() > 0) {
            this.updateLikelihood(ConcentratedLikelihoodComputer.DEFAULT_COMPUTER.compute(this.regarima), spec.getParametersCount());
        }
        return true;
    }

    private boolean optimizeModel(IArimaMapping<SarimaModel> mapping) {
        RegArimaEstimation<SarimaModel> estimation = this.processor.optimize(this.regarima, mapping);
        this.regarima = estimation.getModel();
        this.updateLikelihood(estimation.getConcentratedLikelihood(), estimation.parametersCount());
        return true;
    }

    private void updateLikelihood(ConcentratedLikelihoodWithMissing likelihood, int nhp) {
        this.coeff = likelihood.allCoefficients();
        this.tstats = likelihood.tstats(nhp, true);
        this.res = this.regarima.differencedModel().asLinearModel().calcResiduals(this.coeff);
    }

    private void clear() {
        this.rflag = true;
        this.outliers.clear();
        this.round = 0;
        this.lastremoved = null;
        this.coeff = null;
        this.tstats = null;
        this.estimationStep = true;
        this.backwardStep = false;
        this.exit = false;
        this.res = null;
    }

    private boolean verifyModel() {
        this.estimationStep = true;
        if (this.outliers.isEmpty()) {
            return true;
        }
        int nx0 = this.tstats.length - this.outliers.size();
        int imin = 0;
        for (int i = 1; i < this.outliers.size(); ++i) {
            if (!(Math.abs(this.tstats[i + nx0]) < Math.abs(this.tstats[imin + nx0]))) continue;
            imin = i;
        }
        if (Math.abs(this.tstats[nx0 + imin]) >= this.cv) {
            return true;
        }
        this.backwardStep = false;
        this.estimationStep = false;
        int[] toremove = this.outliers.get(imin);
        this.sod.allow(toremove[0], toremove[1]);
        this.removeOutlier(imin);
        if (this.lastremoved != null && Arrays.equals(toremove, this.lastremoved)) {
            this.exit = true;
        }
        this.lastremoved = toremove;
        return false;
    }

    private void addOutlier(int pos, int type, double c) {
        this.addOutlier(pos, type);
        if (this.coeff == null) {
            this.coeff = Doubles.of((double)c);
        } else {
            double[] tmp = new double[this.coeff.length() + 1];
            this.coeff.copyTo(tmp, 0);
            tmp[this.coeff.length()] = c;
            this.coeff = DoubleSeq.of((double[])tmp);
        }
        this.backwardStep = true;
    }

    private void addOutlier(int pos, int type) {
        int[] o = new int[]{pos, type};
        this.outliers.add(o);
        double[] xo = new double[this.regarima.getObservationsCount()];
        DataBlock XO = DataBlock.of(xo);
        this.sod.getOutlierFactory(type).fill(pos, XO);
        this.regarima = this.regarima.toBuilder().addX((DoubleSeq)XO).build();
        this.sod.exclude(pos, type);
    }

    private void removeOutlier(int idx) {
        int opos = this.regarima.getX().size() - this.outliers.size() + idx;
        this.regarima = this.regarima.toBuilder().removeX(opos).build();
        this.outliers.remove(idx);
        if (this.coeff.length() == 1) {
            this.coeff = null;
        } else {
            int i;
            if (this.regarima.isMean()) {
                ++opos;
            }
            double[] tmp = new double[this.coeff.length() - 1];
            for (i = 0; i < opos; ++i) {
                tmp[i] = this.coeff.get(i);
            }
            for (i = opos + 1; i < this.coeff.length(); ++i) {
                tmp[i - 1] = this.coeff.get(i);
            }
            this.coeff = DoubleSeq.of((double[])tmp);
        }
    }

    public static class Builder {
        private double cv = 0.0;
        private boolean mvx;
        private IRegArimaComputer<SarimaModel> processor;
        private int maxOutliers = DEF_MAXOUTLIERS;
        private int maxRound = DEF_MAXROUND;
        private SingleOutlierDetector<SarimaModel> sod;

        private Builder() {
        }

        public Builder criticalValue(double cv) {
            this.cv = cv;
            return this;
        }

        public Builder maximumLikelihood(boolean mvx) {
            this.mvx = mvx;
            return this;
        }

        public Builder processor(IRegArimaComputer<SarimaModel> processor) {
            this.processor = processor;
            return this;
        }

        public Builder maxOutliers(int max) {
            this.maxOutliers = max;
            return this;
        }

        public Builder maxRound(int max) {
            this.maxRound = max;
            return this;
        }

        public Builder singleOutlierDetector(SingleOutlierDetector<SarimaModel> sod) {
            this.sod = sod;
            return this;
        }

        public FastOutliersDetector build() {
            return new FastOutliersDetector(this.sod, this.processor, this.maxRound, this.maxOutliers, this.cv, this.mvx);
        }
    }
}

