/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.multivariate;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.ssf.IPredictionErrorDecomposition;
import jdplus.toolkit.base.core.ssf.State;
import jdplus.toolkit.base.core.ssf.StateInfo;
import jdplus.toolkit.base.core.ssf.UpdateInformation;
import jdplus.toolkit.base.core.ssf.multivariate.IMultivariateFilteringResults;
import jdplus.toolkit.base.core.ssf.multivariate.IMultivariateSsf;
import jdplus.toolkit.base.core.ssf.multivariate.IMultivariateSsfData;
import jdplus.toolkit.base.core.ssf.multivariate.MultivariateUpdateInformation;
import jdplus.toolkit.base.core.stats.likelihood.Likelihood;
import jdplus.toolkit.base.core.stats.likelihood.ResidualsCumulator;

public class PredictionErrorsDecomposition
implements IPredictionErrorDecomposition,
IMultivariateFilteringResults {
    private final ResidualsCumulator cumulator = new ResidualsCumulator();

    @Override
    public void close() {
    }

    @Override
    public void open(IMultivariateSsf ssf, IMultivariateSsfData data) {
        this.cumulator.clear();
    }

    @Override
    public void save(int t, State state, StateInfo info) {
    }

    @Override
    public void save(int t, MultivariateUpdateInformation pe) {
        if (pe == null) {
            return;
        }
        DataBlock diag = pe.getR().diagonal();
        DoubleSeq err = pe.getU();
        UpdateInformation.Status[] status = pe.getStatus();
        int iv = 0;
        for (int i = 0; i < status.length; ++i) {
            double r;
            if (status[i] == UpdateInformation.Status.MISSING) continue;
            if (status[i] == UpdateInformation.Status.OBSERVATION && (r = diag.get(iv)) != 0.0) {
                this.cumulator.addStd(err.get(iv), r);
            }
            ++iv;
        }
    }

    @Override
    public Likelihood likelihood(boolean scalingfactor) {
        return Likelihood.builder(this.cumulator.getObsCount()).scalingFactor(scalingfactor).ssqErr(this.cumulator.getSsqErr()).logDeterminant(this.cumulator.getLogDeterminant()).build();
    }
}

