# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## Summary

> Given a version number MAJOR.MINOR.PATCH, increment the:
>
> 1. MAJOR version when you make incompatible API changes,
> 2. MINOR version when you add functionality in a backwards compatible manner, and
> 3. PATCH version when you make backwards compatible bug fixes.
>
> Additional labels for pre-release and build metadata are available as extensions to the MAJOR.MINOR.PATCH format.

### Guiding Principles

> Changelogs are for _humans_, not machines.
> There should be an entry for every single version.
> The same types of changes should be grouped.
> Versions and sections should be linkable.
> The latest version comes first.
> The release date of each version is displayed.
> Mention whether you follow [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

### Types of changes

> Added for new features.
> Changed for changes in existing functionality.
> Deprecated for soon-to-be removed features.
> Removed for now removed features.
> Fixed for any bug fixes.
> Security in case of vulnerabilities.
## [Unreleased]

## [Unreleased]

### Added

- 

### Changed

- 

### Deprecated

-

### Removed

- 

### Fixed

-

### Security

-

## [0.1.0] - 2020-04-28

### Added

- Unit tests for new `runes()` futhark argument option
- New param for the `runes()` function to determine which futhark set to use
- Forgotten runes Eiwaz conversion added in
- New 'branch' argument for younger futhark runes to pick either long branch or short twig younger futhark runes [Younger Futhark](https://en.wikipedia.org/wiki/Younger_Futhark)
- Younger futhark rune translations
- `runes_table()` now has `futhark` and `branch` arguments so you can differentiate which translation table you'd like be it elder, younger-short, or younger-long

### Changed

- Added new function options to `runes()` it will now accept a new argument "futhark" which defaults to "elder" to maintain prior functionality but now different futhark rune sets can be chosen such as younger futhark
- fixed character conversion for the elder futhark set, some conversions like ng for inguaz are actually linked to a unicode character not a dual character ascii 'ng', the same goes for 'th' which is the thorisaz runes and now requires the unicode character to be translated into that character again where as 'th' will translate to Tiwaz and Hagalaz

### Deprecated

-

### Removed

- Removed the internal `tolower()` functionality as some rune sets have case sensitive conversions and with regex the case wont matter for the other sets if [aA] is used for 'A' in the elder sets
- Redundant and superfluous unit tests

### Fixed

- translations in elder futhark, some were incorrect.

### Security

-

## [0.0.1] - 2020-01-22

### Added

- Core functionality of a-z alphabet translation to Elder Futhark
- all special characters, numeric, or otherwise all ignored as pass through
- New function `runes_table()` create a 3 column data frame with the unicode sequence, transcription, and character of the entire Elder Futhark alphabet to be used for inputting into documents, reference, or any other purpose

### Changed

- new parameter to `runes()` `hide=FALSE` is now the default option but when set to true, the English 'x' & 'q' characters will not pass through the function and appear at all since there is no equivalent rune.
    + added unit tests to support this new parameter option

### Deprecated

-

### Removed

-

### Fixed

-

### Security

-

