/*
 * Decompiled with CFR 0.152.
 */
package core.explorer;

import core.lattice.Lattice;
import core.model.DecomposableModel;
import core.model.GraphAction;
import core.stats.MyPriorityQueue;
import core.stats.scorer.GraphActionScorer;
import java.util.ArrayList;

public abstract class ChordalysisModeller {
    protected DecomposableModel bestModel;
    protected Lattice lattice;
    protected MyPriorityQueue pq;
    protected ArrayList<GraphAction> operationsPerformed;
    protected GraphActionScorer scorer;
    protected int maxNSteps;

    private ChordalysisModeller() {
        throw new AssertionError((Object)"Instantiating utility class.");
    }

    protected ChordalysisModeller(Data data) {
        this.bestModel = data.bestModel;
        this.lattice = data.lattice;
        this.maxNSteps = Integer.MAX_VALUE;
        this.operationsPerformed = new ArrayList();
        this.scorer = null;
        this.pq = null;
    }

    public DecomposableModel getModel() {
        return this.bestModel;
    }

    public Lattice getLattice() {
        return this.lattice;
    }

    public int getNbInstances() {
        return this.lattice.getNbInstances();
    }

    public void setMaxNSteps(int nSteps) {
        this.maxNSteps = nSteps;
    }

    public abstract void explore();

    protected abstract GraphActionScorer initScorer();

    public void buildModel() {
        this.buildModelNoExplore();
        this.explore();
    }

    public void buildModelNoExplore() {
        int vl = this.lattice.getNbVariables();
        this.scorer = this.initScorer();
        this.pq = new MyPriorityQueue(vl, this.bestModel, this.scorer);
        int i = 0;
        while (i < vl) {
            int j = i + 1;
            while (j < vl) {
                this.pq.enableEdge(i, j);
                ++j;
            }
            ++i;
        }
    }

    public static class Data {
        private DecomposableModel bestModel;
        private Lattice lattice;

        public Data(DecomposableModel bm, Lattice l) {
            this.bestModel = bm;
            this.lattice = l;
        }
    }
}

