/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

import umontreal.iro.lecuyer.hups.PointSet;
import umontreal.iro.lecuyer.hups.RadicalInverse;

public class HaltonSequence
extends PointSet {
    private int[] base;
    private int[][] permutation;
    private boolean permuted;
    private RadicalInverse[] radinv;

    public HaltonSequence(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Halton sequence must have positive dimension dim");
        }
        this.dim = n;
        this.numPoints = Integer.MAX_VALUE;
        this.base = RadicalInverse.getPrimes(n);
    }

    public void init(double[] dArray) {
        this.radinv = new RadicalInverse[this.dim];
        for (int i = 0; i < this.dim; ++i) {
            this.radinv[i] = new RadicalInverse(this.base[i], dArray[i]);
        }
    }

    public void addFaurePermutations() {
        this.permutation = new int[this.dim][];
        for (int i = 0; i < this.dim; ++i) {
            this.permutation[i] = new int[this.base[i]];
            RadicalInverse.getFaurePermutation(this.base[i], this.permutation[i]);
        }
        this.permuted = true;
    }

    public void ErasePermutations() {
        this.permuted = false;
        this.permutation = null;
    }

    public int getNumPoints() {
        return Integer.MAX_VALUE;
    }

    public double getCoordinate(int n, int n2) {
        if (this.radinv != null) {
            if (!this.permuted) {
                return this.radinv[n2].nextRadicalInverse();
            }
            throw new UnsupportedOperationException("Fast radical inverse is not implemented in case of permutation");
        }
        if (this.permuted) {
            return RadicalInverse.permutedRadicalInverse(this.base[n2], this.permutation[n2], n);
        }
        return RadicalInverse.radicalInverse(this.base[n2], n);
    }
}

