/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import org.xmlcml.euclid.EuclidConstants;
import org.xmlcml.euclid.Real2;
import org.xmlcml.euclid.Real2Range;
import org.xmlcml.euclid.RealInterval;

public class Real2Interval
implements EuclidConstants {
    RealInterval xInterval;
    RealInterval yInterval;

    public Real2Interval() {
        this(new RealInterval(), new RealInterval());
    }

    public Real2Interval(RealInterval xInterval, RealInterval yInterval) {
        this.xInterval = new RealInterval(xInterval);
        this.yInterval = new RealInterval(yInterval);
    }

    public Real2Interval(Real2Interval xyInterval) {
        this(xyInterval.xInterval, xyInterval.yInterval);
    }

    public Real2Interval(Real2Range range2) {
        this(new RealInterval(range2.getXRange()), new RealInterval(range2.getYRange()));
    }

    public double[] scalesTo(Real2Interval interval2) {
        double[] scales = new double[]{this.xInterval.scaleTo(interval2.xInterval), this.yInterval.scaleTo(interval2.yInterval)};
        return scales;
    }

    public double scaleTo(Real2Interval interval2) {
        double scale = Double.NaN;
        double[] scales = this.scalesTo(interval2);
        scale = Double.isNaN(scales[0]) ? scales[1] : (Double.isNaN(scales[1]) ? scales[0] : Math.min(scales[0], scales[0]));
        return scale;
    }

    public double[] offsetsTo(Real2Interval interval2, double[] scales) {
        double[] offsets = new double[]{this.xInterval.offsetTo(interval2.xInterval, scales[0]), this.yInterval.offsetTo(interval2.yInterval, scales[1])};
        return offsets;
    }

    public double[] offsetsTo(Real2Interval interval2, double scale) {
        return this.offsetsTo(interval2, new double[]{scale, scale});
    }

    public double[] offsetsTo(Real2Interval interval2) {
        double[] offsets = new double[]{this.xInterval.offsetTo(interval2.xInterval), this.yInterval.offsetTo(interval2.yInterval)};
        return offsets;
    }

    public Real2 midPoint() {
        return new Real2(this.xInterval.midPoint(), this.yInterval.midPoint());
    }
}

