/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jdplus.sa.base.api.SaSpecification;
import jdplus.toolkit.base.api.information.GenericExplorable;
import jdplus.toolkit.base.api.processing.ProcDiagnostic;
import jdplus.toolkit.base.api.processing.ProcQuality;
import lombok.Generated;
import org.jspecify.annotations.NonNull;

public class SaEstimation {
    private final GenericExplorable results;
    private final List<ProcDiagnostic> diagnostics;
    private final List<String> warnings;
    private final ProcQuality quality;
    private final SaSpecification pointSpec;

    public List<String> warnings() {
        return Collections.unmodifiableList(this.warnings);
    }

    SaEstimation flush() {
        if (this.results == null) {
            return this;
        }
        return SaEstimation.builder().pointSpec(this.pointSpec).quality(this.quality).build();
    }

    @Generated
    public static @NonNull Builder builder() {
        return new Builder();
    }

    @Generated
    public @NonNull Builder toBuilder() {
        Builder builder = new Builder().results(this.results).quality(this.quality).pointSpec(this.pointSpec);
        if (this.diagnostics != null) {
            builder.diagnostics(this.diagnostics);
        }
        if (this.warnings != null) {
            builder.warnings(this.warnings);
        }
        return builder;
    }

    @Generated
    public GenericExplorable getResults() {
        return this.results;
    }

    @Generated
    public List<ProcDiagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    @Generated
    public List<String> getWarnings() {
        return this.warnings;
    }

    @Generated
    public ProcQuality getQuality() {
        return this.quality;
    }

    @Generated
    public SaSpecification getPointSpec() {
        return this.pointSpec;
    }

    @Generated
    public SaEstimation(GenericExplorable results, List<ProcDiagnostic> diagnostics, List<String> warnings, ProcQuality quality, SaSpecification pointSpec) {
        this.results = results;
        this.diagnostics = diagnostics;
        this.warnings = warnings;
        this.quality = quality;
        this.pointSpec = pointSpec;
    }

    @Generated
    public @NonNull SaEstimation withQuality(ProcQuality quality) {
        return this.quality == quality ? this : new SaEstimation(this.results, this.diagnostics, this.warnings, quality, this.pointSpec);
    }

    @Generated
    public static class Builder {
        @Generated
        private GenericExplorable results;
        @Generated
        private ArrayList<ProcDiagnostic> diagnostics;
        @Generated
        private ArrayList<String> warnings;
        @Generated
        private ProcQuality quality;
        @Generated
        private SaSpecification pointSpec;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder results(GenericExplorable results) {
            this.results = results;
            return this;
        }

        @Generated
        public @NonNull Builder diagnostic(ProcDiagnostic diagnostic) {
            if (this.diagnostics == null) {
                this.diagnostics = new ArrayList();
            }
            this.diagnostics.add(diagnostic);
            return this;
        }

        @Generated
        public @NonNull Builder diagnostics(@NonNull Collection<? extends ProcDiagnostic> diagnostics) {
            if (diagnostics == null) {
                throw new NullPointerException("diagnostics cannot be null");
            }
            if (this.diagnostics == null) {
                this.diagnostics = new ArrayList();
            }
            this.diagnostics.addAll(diagnostics);
            return this;
        }

        @Generated
        public @NonNull Builder clearDiagnostics() {
            if (this.diagnostics != null) {
                this.diagnostics.clear();
            }
            return this;
        }

        @Generated
        public @NonNull Builder warning(String warning) {
            if (this.warnings == null) {
                this.warnings = new ArrayList();
            }
            this.warnings.add(warning);
            return this;
        }

        @Generated
        public @NonNull Builder warnings(@NonNull Collection<? extends String> warnings) {
            if (warnings == null) {
                throw new NullPointerException("warnings cannot be null");
            }
            if (this.warnings == null) {
                this.warnings = new ArrayList();
            }
            this.warnings.addAll(warnings);
            return this;
        }

        @Generated
        public @NonNull Builder clearWarnings() {
            if (this.warnings != null) {
                this.warnings.clear();
            }
            return this;
        }

        @Generated
        public @NonNull Builder quality(ProcQuality quality) {
            this.quality = quality;
            return this;
        }

        @Generated
        public @NonNull Builder pointSpec(SaSpecification pointSpec) {
            this.pointSpec = pointSpec;
            return this;
        }

        @Generated
        public @NonNull SaEstimation build() {
            return new SaEstimation(this.results, switch (this.diagnostics == null ? 0 : this.diagnostics.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.diagnostics.get(0));
                default -> Collections.unmodifiableList(new ArrayList<ProcDiagnostic>(this.diagnostics));
            }, switch (this.warnings == null ? 0 : this.warnings.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.warnings.get(0));
                default -> Collections.unmodifiableList(new ArrayList<String>(this.warnings));
            }, this.quality, this.pointSpec);
        }

        @Generated
        public @NonNull String toString() {
            return "SaEstimation.Builder(results=" + String.valueOf(this.results) + ", diagnostics=" + String.valueOf(this.diagnostics) + ", warnings=" + String.valueOf(this.warnings) + ", quality=" + String.valueOf(this.quality) + ", pointSpec=" + String.valueOf(this.pointSpec) + ")";
        }
    }
}

