/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.data;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.api.data.Doubles;
import lombok.Generated;

public final class DoublesMath {
    public static double sum(DoubleSeq src) {
        return src.reduce(0.0, (s, x) -> s + x);
    }

    public static double average(DoubleSeq src) {
        return src.reduce(0.0, (s, x) -> s + x) / (double)src.length();
    }

    public static double ssq(DoubleSeq src) {
        return src.reduce(0.0, (s, x) -> s + x * x);
    }

    public static double ssqc(DoubleSeq src, double mean) {
        return src.reduce(0.0, (s, x) -> s + (x -= mean) * x);
    }

    public static double sumWithMissing(DoubleSeq src) {
        int n = src.length();
        double result = 0.0;
        DoubleSeqCursor cursor = src.cursor();
        for (int i = 0; i < n; ++i) {
            double value = cursor.getAndNext();
            if (!Double.isFinite(value)) continue;
            result += value;
        }
        return result;
    }

    public static double ssqWithMissing(DoubleSeq src) {
        int n = src.length();
        double result = 0.0;
        DoubleSeqCursor cursor = src.cursor();
        for (int i = 0; i < n; ++i) {
            double value = cursor.getAndNext();
            if (!Double.isFinite(value)) continue;
            result += value * value;
        }
        return result;
    }

    public static double ssqcWithMissing(DoubleSeq src, double mean) {
        int n = src.length();
        double result = 0.0;
        DoubleSeqCursor cursor = src.cursor();
        for (int i = 0; i < n; ++i) {
            double x = cursor.getAndNext();
            if (!Double.isFinite(x)) continue;
            double value = x - mean;
            result += value * value;
        }
        return result;
    }

    public static double averageWithMissing(DoubleSeq src) {
        int n = src.length();
        int m = 0;
        double s = 0.0;
        DoubleSeqCursor cursor = src.cursor();
        for (int i = 0; i < n; ++i) {
            double value = cursor.getAndNext();
            if (Double.isFinite(value)) {
                s += value;
                continue;
            }
            ++m;
        }
        return s / (double)(n - m);
    }

    public static double norm1(DoubleSeq src) {
        int n = src.length();
        double result = 0.0;
        DoubleSeqCursor cursor = src.cursor();
        for (int i = 0; i < n; ++i) {
            result += Math.abs(cursor.getAndNext());
        }
        return result;
    }

    public static double norm2(DoubleSeq src) {
        int n = src.length();
        switch (n) {
            case 0: {
                return 0.0;
            }
            case 1: {
                return Math.abs(src.get(0));
            }
        }
        double scale = 0.0;
        double ssq = 1.0;
        DoubleSeqCursor cursor = src.cursor();
        for (int i = 0; i < n; ++i) {
            double s;
            double value = cursor.getAndNext();
            if (value == 0.0) continue;
            double absxi = Math.abs(value);
            if (scale < absxi) {
                s = scale / absxi;
                ssq = 1.0 + ssq * s * s;
                scale = absxi;
                continue;
            }
            s = absxi / scale;
            ssq += s * s;
        }
        return scale * Math.sqrt(ssq);
    }

    public static double fastNorm2(DoubleSeq src) {
        int n = src.length();
        switch (n) {
            case 0: {
                return 0.0;
            }
            case 1: {
                return Math.abs(src.get(0));
            }
        }
        DoubleSeqCursor cursor = src.cursor();
        double ssq = 0.0;
        for (int i = 0; i < n; ++i) {
            double value = cursor.getAndNext();
            if (value == 0.0) continue;
            ssq += value * value;
        }
        return Math.sqrt(ssq);
    }

    public static double normInf(DoubleSeq src) {
        int n = src.length();
        if (n == 0) {
            return 0.0;
        }
        double nrm = Math.abs(src.get(0));
        DoubleSeqCursor cursor = src.cursor();
        for (int i = 1; i < n; ++i) {
            double value = Math.abs(cursor.getAndNext());
            if (!(value > nrm)) continue;
            nrm = value;
        }
        return nrm;
    }

    public static int getRepeatCount(DoubleSeq src) {
        int i = 0;
        int n = src.length();
        DoubleSeqCursor cursor = src.cursor();
        double prev = 0.0;
        while (i++ < n && !Double.isFinite(prev = cursor.getAndNext())) {
        }
        if (i == n) {
            return 0;
        }
        int c = 0;
        while (i < n) {
            double value = cursor.getAndNext();
            if (Double.isFinite(value)) {
                if (value == prev) {
                    ++c;
                } else {
                    prev = value;
                }
            }
            ++i;
        }
        return c;
    }

    public static double dot(DoubleSeq a, DoubleSeq b) {
        int n = a.length();
        double s = 0.0;
        DoubleSeqCursor cur = a.cursor();
        DoubleSeqCursor xcur = b.cursor();
        for (int i = 0; i < n; ++i) {
            s += cur.getAndNext() * xcur.getAndNext();
        }
        return s;
    }

    public static double jdot(DoubleSeq a, DoubleSeq b, int pos) {
        int i;
        int n = a.length();
        double s = 0.0;
        DoubleSeqCursor cur = a.cursor();
        DoubleSeqCursor xcur = b.cursor();
        for (i = 0; i < pos; ++i) {
            s += cur.getAndNext() * xcur.getAndNext();
        }
        for (i = pos; i < n; ++i) {
            s -= cur.getAndNext() * xcur.getAndNext();
        }
        return s;
    }

    public static double distance(DoubleSeq a, DoubleSeq b) {
        double scale = 0.0;
        double ssq = 1.0;
        DoubleSeqCursor cur = a.cursor();
        DoubleSeqCursor xcur = b.cursor();
        int n = a.length();
        for (int i = 0; i < n; ++i) {
            double s;
            double d;
            double y;
            double x = cur.getAndNext();
            if (Double.compare(x, y = xcur.getAndNext()) == 0 || (d = x - y) == 0.0) continue;
            double absxi = Math.abs(d);
            if (scale < absxi) {
                s = scale / absxi;
                ssq = 1.0 + ssq * s * s;
                scale = absxi;
                continue;
            }
            s = absxi / scale;
            ssq += s * s;
        }
        return scale * Math.sqrt(ssq);
    }

    public static DoubleSeq removeMean(DoubleSeq src) {
        int i;
        double[] safeArray = src.toArray();
        double s = 0.0;
        for (i = 0; i < safeArray.length; ++i) {
            s += safeArray[i];
        }
        s /= (double)safeArray.length;
        i = 0;
        while (i < safeArray.length) {
            int n = i++;
            safeArray[n] = safeArray[n] - s;
        }
        return Doubles.ofInternal(safeArray);
    }

    public static DoubleSeq delta(DoubleSeq src, int lag) {
        return src.fn(lag, (x, y) -> y - x);
    }

    public static DoubleSeq delta(DoubleSeq src, int lag, int pow) {
        DoubleSeq result = src;
        for (int i = 0; i < pow; ++i) {
            result = result.fn(lag, (x, y) -> y - x);
        }
        return result;
    }

    public static DoubleSeq log(DoubleSeq src) {
        return src.fn(Math::log);
    }

    public static DoubleSeq exp(DoubleSeq src) {
        return src.fn(Math::exp);
    }

    public static DoubleSeq add(DoubleSeq a, DoubleSeq ... b) {
        double[] tot;
        int start = -1;
        if (b != null) {
            for (int i = 0; i < b.length; ++i) {
                if (b[i] == null) continue;
                start = i;
                break;
            }
        }
        if (start == -1) {
            return a;
        }
        if (a != null) {
            tot = a.toArray();
        } else {
            if (start == b.length - 1) {
                return b[start];
            }
            tot = b[start++].toArray();
        }
        for (int i = start; i < b.length; ++i) {
            if (tot.length != b[i].length()) {
                throw new IllegalArgumentException("wrong dimensions");
            }
            DoubleSeqCursor cursor = b[i].cursor();
            int j = 0;
            while (j < tot.length) {
                int n = j++;
                tot[n] = tot[n] + cursor.getAndNext();
            }
        }
        return Doubles.ofInternal(tot);
    }

    public static DoubleSeq concatenate(DoubleSeq ... b) {
        if (b == null) {
            throw new NullPointerException("b is marked non-null but is null");
        }
        if (b.length == 1) {
            return b[0];
        }
        int n = 0;
        for (int i = 0; i < b.length; ++i) {
            if (b[i] == null) continue;
            n += b[i].length();
        }
        if (n == 0) {
            return Doubles.EMPTY;
        }
        double[] d = new double[n];
        int j = 0;
        for (int i = 0; i < b.length; ++i) {
            if (b[i] == null) continue;
            b[i].copyTo(d, j);
            j += b[i].length();
        }
        return Doubles.ofInternal(d);
    }

    public static DoubleSeq subtract(DoubleSeq a, DoubleSeq b) {
        if (b == null) {
            return a;
        }
        if (a == null) {
            return b.fn(x -> -x);
        }
        if (a.length() != b.length()) {
            throw new IllegalArgumentException("wrong dimensions");
        }
        return a.fn(b, (x, y) -> x - y);
    }

    public static DoubleSeq multiply(DoubleSeq a, DoubleSeq ... b) {
        double[] prod;
        int start = -1;
        if (b != null) {
            for (int i = 0; i < b.length; ++i) {
                if (b[i] == null) continue;
                start = i;
                break;
            }
        }
        if (start == -1) {
            return a;
        }
        if (a != null) {
            prod = a.toArray();
        } else {
            if (start == b.length - 1) {
                return b[start];
            }
            prod = b[start++].toArray();
        }
        for (int i = start; i < b.length; ++i) {
            if (prod.length != b[i].length()) {
                throw new IllegalArgumentException("wrong dimensions");
            }
            DoubleSeqCursor cursor = b[i].cursor();
            int j = 0;
            while (j < prod.length) {
                int n = j++;
                prod[n] = prod[n] * cursor.getAndNext();
            }
        }
        return Doubles.ofInternal(prod);
    }

    public static DoubleSeq divide(DoubleSeq a, DoubleSeq b) {
        if (a == null) {
            return b.fn(x -> 1.0 / x);
        }
        if (b == null) {
            return a;
        }
        if (a.length() != b.length()) {
            throw new IllegalArgumentException("wrong dimensions");
        }
        return a.fn(b, (x, y) -> x / y);
    }

    @Generated
    private DoublesMath() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

