/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling.regression;

import java.time.LocalDate;
import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import jdplus.toolkit.base.api.timeseries.TimeSeriesInterval;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.calendars.Easter;
import jdplus.toolkit.base.api.timeseries.regression.EasterVariable;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.modelling.regression.RegressionVariableFactory;

class EasterFactory
implements RegressionVariableFactory<EasterVariable> {
    private static final double[] MEANS_FEB = new double[]{0.00368, 0.002083333, 0.001130435, 2.727273E-4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    private static final double[] MEANS_MAR = new double[]{0.6576, 0.6450833, 0.6311304, 0.6162727, 0.5999048, 0.583, 0.5661053, 0.549, 0.5318824, 0.514625, 0.4973333, 0.4807143, 0.4643077, 0.4476667, 0.4305455, 0.4136, 0.3975556, 0.382, 0.3654286, 0.3483333, 0.3304, 0.3125, 0.2966667, 0.281, 0.266};
    private static final double[] MEANS_APR = new double[]{0.33872, 0.3528333, 0.3677391, 0.3834545, 0.4000952, 0.417, 0.4338947, 0.451, 0.4681176, 0.485375, 0.5026667, 0.5192857, 0.5356923, 0.5523333, 0.5694545, 0.5864, 0.6024444, 0.618, 0.6345714, 0.6516667, 0.6696, 0.6875, 0.7033333, 0.719, 0.734};
    static EasterFactory FACTORY = new EasterFactory();

    private EasterFactory() {
    }

    @Override
    public boolean fill(EasterVariable var, TsPeriod start, FastMatrix buffer, ProcessingLog log) {
        int idx;
        if (start.getUnit().getAnnualFrequency() <= 3) {
            return false;
        }
        int duration = var.getDuration();
        int endPosition = var.getEndPosition();
        EasterVariable.Correction meanCorrection = var.getMeanCorrection();
        DataBlock data = buffer.column(0);
        int freq = start.getUnit().getAnnualFrequency();
        if (freq != 12 && freq != 4) {
            return false;
        }
        int n = data.length();
        int c = 12 / freq;
        int y0 = start.start().getYear();
        int p0 = start.start().getMonthValue();
        if (p0 > 4) {
            p0 -= 12;
            ++y0;
        }
        if ((idx = (4 - p0) / c) > n) {
            return true;
        }
        double dur = duration;
        int y = y0;
        while (idx <= n) {
            LocalDate easter = Easter.easter((int)y);
            int day = easter.getDayOfMonth();
            int month = easter.getMonthValue();
            if (endPosition == -1) {
                --day;
            } else if (endPosition == 1) {
                if (day == 31) {
                    day = 1;
                    ++month;
                } else {
                    ++day;
                }
            }
            double m = 0.0;
            double a = 0.0;
            if (meanCorrection == EasterVariable.Correction.Simple) {
                if (month == 3 || day == 0) {
                    m = 0.5;
                    a = -0.5;
                } else if (day >= duration) {
                    m = -0.5;
                    a = 0.5;
                } else {
                    m = (dur - (double)day) / dur - 0.5;
                    a = -m;
                }
            } else {
                double m_av = 0.0;
                double a_av = 0.0;
                if (meanCorrection == EasterVariable.Correction.PreComputed) {
                    m_av = MEANS_MAR[25 - duration];
                    a_av = MEANS_APR[25 - duration];
                } else if (meanCorrection == EasterVariable.Correction.Theoretical) {
                    m_av = (15.0 + dur) / 59.06118;
                    a_av = 1.0 - m_av;
                }
                if (month == 3) {
                    m = 1.0 - m_av;
                    a = -a_av;
                } else if (day >= duration) {
                    m = -m_av;
                    a = 1.0 - a_av;
                } else {
                    m = (dur - (double)day) / dur - m_av;
                    a = (double)day / dur - a_av;
                }
            }
            if (idx - 1 >= 0) {
                data.set(idx - 1, m);
            }
            if (idx < n) {
                data.set(idx, a);
            }
            ++y;
            idx += freq;
        }
        return true;
    }

    @Override
    public <P extends TimeSeriesInterval<?>, D extends TimeSeriesDomain<P>> boolean fill(EasterVariable var, D domain, FastMatrix buffer, ProcessingLog log) {
        throw new UnsupportedOperationException("Not supported.");
    }
}

