/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regsarima.regular;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.arima.SarimaSpec;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.api.data.Doubles;
import jdplus.toolkit.base.api.data.Parameter;
import jdplus.toolkit.base.api.data.ParametersEstimation;
import jdplus.toolkit.base.api.information.GenericExplorable;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.stats.ProbabilityType;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.TsResiduals;
import jdplus.toolkit.base.api.timeseries.calendars.DayClustering;
import jdplus.toolkit.base.api.timeseries.regression.GenericTradingDaysVariable;
import jdplus.toolkit.base.api.timeseries.regression.HolidaysCorrectedTradingDays;
import jdplus.toolkit.base.api.timeseries.regression.ITradingDaysVariable;
import jdplus.toolkit.base.api.timeseries.regression.ITsVariable;
import jdplus.toolkit.base.api.timeseries.regression.MissingValueEstimation;
import jdplus.toolkit.base.api.timeseries.regression.RegressionItem;
import jdplus.toolkit.base.api.timeseries.regression.ResidualsType;
import jdplus.toolkit.base.api.timeseries.regression.TrendConstant;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.api.util.Arrays2;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.arima.estimation.IArimaMapping;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.dstats.F;
import jdplus.toolkit.base.core.dstats.LogNormal;
import jdplus.toolkit.base.core.dstats.T;
import jdplus.toolkit.base.core.math.functions.IFunction;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.LowerTriangularMatrix;
import jdplus.toolkit.base.core.math.matrices.QuadraticForm;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.modelling.GeneralLinearModel;
import jdplus.toolkit.base.core.modelling.LightweightLinearModel;
import jdplus.toolkit.base.core.modelling.regression.RegressionDesc;
import jdplus.toolkit.base.core.regarima.RegArimaEstimation;
import jdplus.toolkit.base.core.regarima.RegArimaForecasts;
import jdplus.toolkit.base.core.regarima.RegArimaModel;
import jdplus.toolkit.base.core.regarima.RegArimaUtility;
import jdplus.toolkit.base.core.regarima.RegArmaModel;
import jdplus.toolkit.base.core.regarima.estimation.RegArmaFunction;
import jdplus.toolkit.base.core.regsarima.RegSarimaComputer;
import jdplus.toolkit.base.core.regsarima.regular.ModelDescription;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.toolkit.base.core.sarima.estimation.SarimaFixedMapping;
import jdplus.toolkit.base.core.sarima.estimation.SarimaMapping;
import jdplus.toolkit.base.core.ssf.arima.ExactArimaForecasts;
import jdplus.toolkit.base.core.stats.likelihood.ConcentratedLikelihoodWithMissing;
import jdplus.toolkit.base.core.stats.likelihood.DefaultLikelihoodEvaluation;
import jdplus.toolkit.base.core.stats.likelihood.LikelihoodStatistics;
import jdplus.toolkit.base.core.stats.likelihood.LogLikelihoodFunction;
import jdplus.toolkit.base.core.stats.tests.NiidTests;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class RegSarimaModel
implements GeneralLinearModel<SarimaSpec>,
GenericExplorable {
    private static final MissingValueEstimation[] NOMISSING = new MissingValueEstimation[0];
    private final ConcurrentMap<String, Object> cache = new ConcurrentHashMap<String, Object>();
    private final Map<String, Object> additionalResults;
    private final GeneralLinearModel.Description<SarimaSpec> description;
    private final GeneralLinearModel.Estimation estimation;
    private final TsResiduals residuals;
    private final Details details;

    public static RegSarimaModel of(ModelDescription model, RegSarimaComputer processor) {
        return RegSarimaModel.of(model, processor.process(model.regarima(), model.mapping()), ProcessingLog.dummy());
    }

    public static RegSarimaModel of(ModelDescription description, RegArimaEstimation<SarimaModel> estimation, ProcessingLog log) {
        SarimaSpec arima = description.getArimaSpec();
        int free = arima.freeParametersCount();
        RegArimaModel<SarimaModel> model = estimation.getModel();
        ConcentratedLikelihoodWithMissing ll = estimation.getConcentratedLikelihood();
        LikelihoodStatistics statistics = estimation.statistics();
        List vars = ((Stream)description.variables().sequential()).collect(Collectors.toList());
        int nvars = vars.size();
        if (description.isMean()) {
            ++nvars;
        }
        Variable[] variables = new Variable[nvars];
        DoubleSeq coeffs = estimation.getConcentratedLikelihood().coefficients();
        DoubleSeqCursor cursor = coeffs.cursor();
        FastMatrix varcoeffs = estimation.getConcentratedLikelihood().unscaledCovariance();
        DoubleSeqCursor.OnMutable diag = varcoeffs.diagonal().cursor();
        int df = ll.degreesOfFreedom() - free;
        double vscale = ll.ssq() / (double)df;
        T tstat = new T(df);
        int k = 0;
        int pos = 0;
        ArrayList<RegressionDesc> regressionDesc = new ArrayList<RegressionDesc>();
        if (description.isMean()) {
            TrendConstant cur = new TrendConstant(arima.getD(), arima.getBd(), description.getEstimationDomain().start());
            double c = cursor.getAndNext();
            double e = Math.sqrt(diag.getAndNext() * vscale);
            regressionDesc.add(new RegressionDesc("const", (ITsVariable)cur, 0, pos++, c, e, 2.0 * tstat.getProbability(Math.abs(c / e), ProbabilityType.Upper)));
            variables[k++] = Variable.variable((String)"const", (ITsVariable)cur).withCoefficient(Parameter.estimated((double)c));
        }
        TsDomain domain = description.getDomain();
        StatisticalTest tdf = null;
        RegressionDesc tdderived = null;
        for (Variable var : vars) {
            int nfree = var.freeCoefficientsCount();
            if (nfree == var.dim() && nfree > 1) {
                int startpos = pos;
                Parameter[] p = new Parameter[nfree];
                for (int j = 0; j < nfree; ++j) {
                    double c = cursor.getAndNext();
                    double e = Math.sqrt(diag.getAndNext() * vscale);
                    if (e == 0.0) {
                        p[j] = Parameter.zero();
                        regressionDesc.add(new RegressionDesc(var.getCore().description(j, (TimeSeriesDomain)domain), var.getCore(), j, pos++, 0.0, 0.0, 0.0));
                        continue;
                    }
                    p[j] = Parameter.estimated((double)c);
                    regressionDesc.add(new RegressionDesc(var.getCore().description(j, (TimeSeriesDomain)domain), var.getCore(), j, pos++, c, e, 2.0 * tstat.getProbability(Math.abs(c / e), ProbabilityType.Upper)));
                }
                variables[k++] = var.withCoefficients(p);
                ITsVariable c = var.getCore();
                if (!(c instanceof ITradingDaysVariable)) continue;
                ITradingDaysVariable iTradingDaysVariable = (ITradingDaysVariable)c;
                DoubleSeq coef = coeffs.extract(startpos, nfree);
                FastMatrix bvar = FastMatrix.of((Matrix)varcoeffs.extract(startpos, nfree, startpos, nfree));
                DataBlock w = RegSarimaModel.weights(iTradingDaysVariable);
                if (w != null) {
                    double c2 = -coef.dot((DoubleSeq)w);
                    double v = QuadraticForm.apply(bvar, w);
                    double e = Math.sqrt(v * vscale);
                    tdderived = new RegressionDesc("td-derived", var.getCore(), -1, -1, c2, e, 2.0 * tstat.getProbability(Math.abs(c2 / e), ProbabilityType.Upper));
                }
                try {
                    SymmetricMatrix.lcholesky(bvar);
                    DataBlock r = DataBlock.of(coef);
                    LowerTriangularMatrix.solveLx(bvar, r);
                    double f = r.ssq() / (vscale * (double)nfree);
                    F fdist = new F(nfree, df);
                    double pval = fdist.getProbability(f, ProbabilityType.Upper);
                    tdf = new StatisticalTest(f, pval, fdist.getDescription());
                }
                catch (Exception r) {}
                continue;
            }
            if (nfree > 0) {
                Parameter[] p = var.getCoefficients();
                for (int j = 0; j < p.length; ++j) {
                    if (!p[j].isFree()) continue;
                    double c = cursor.getAndNext();
                    double e = Math.sqrt(diag.getAndNext() * vscale);
                    p[j] = Parameter.estimated((double)c);
                    regressionDesc.add(new RegressionDesc(p.length > 1 ? var.getCore().description(j, (TimeSeriesDomain)domain) : var.getCore().description((TimeSeriesDomain)domain), var.getCore(), j, pos++, c, e, 2.0 * tstat.getProbability(Math.abs(c / e), ProbabilityType.Upper)));
                }
                variables[k++] = var.withCoefficients(p);
                continue;
            }
            variables[k++] = var;
        }
        LightweightLinearModel.Description<SarimaSpec> desc = LightweightLinearModel.Description.builder().series(description.getSeries()).lengthOfPeriodTransformation(description.getPreadjustment()).logTransformation(description.isLogTransformation()).variables(variables).stochasticComponent(arima).build();
        LogLikelihoodFunction.Point<RegArimaModel<SarimaModel>, ConcentratedLikelihoodWithMissing> max = estimation.getMax();
        ParametersEstimation pestim = max == null ? new ParametersEstimation((DoubleSeq)Doubles.EMPTY, (Matrix)FastMatrix.EMPTY, (DoubleSeq)Doubles.EMPTY, null) : new ParametersEstimation(max.getParameters(), (Matrix)max.asymptoticCovariance(), max.getScore(), "sarima (true signs)");
        int nmissing = ll.nmissing();
        MissingValueEstimation[] missing = NOMISSING;
        if (nmissing > 0) {
            DoubleSeq y = model.getY();
            missing = new MissingValueEstimation[nmissing];
            DoubleSeqCursor cur = ll.missingCorrections().cursor();
            DoubleSeqCursor vcur = ll.missingUnscaledVariances().cursor();
            int[] pmissing = model.missing();
            for (int i = 0; i < nmissing; ++i) {
                double m = cur.getAndNext();
                double v = vcur.getAndNext();
                missing[i] = new MissingValueEstimation(pmissing[i], y.get(pmissing[i]) - m, Math.sqrt(v * vscale));
            }
        }
        DoubleSeq fullRes = RegArimaUtility.fullResiduals(model, ll);
        LightweightLinearModel.Estimation est = LightweightLinearModel.Estimation.builder().domain(description.getEstimationDomain()).y(model.getY()).X(model.allVariables()).coefficients(ll.coefficients()).coefficientsCovariance((Matrix)ll.covariance(free, true)).parameters(pestim).statistics(statistics).missing(missing).logs(log.all()).build();
        int period = desc.getSeries().getAnnualFrequency();
        NiidTests niid = NiidTests.builder().data(fullRes).period(period).hyperParametersCount(free).build();
        TsPeriod start = description.getEstimationDomain().getEndPeriod().plus((long)(-fullRes.length()));
        TsResiduals residuals = TsResiduals.builder().type(ResidualsType.QR_Transformed).res(ll.e()).ssq(ll.ssq()).n(ll.dim()).df(ll.degreesOfFreedom()).dfc(df).tsres(TsData.of((TsPeriod)start, (DoubleSeq)fullRes)).test("mean", niid.meanTest()).test("skewness", niid.skewness()).test("kurtosis", niid.kurtosis()).test("doornikhansen", niid.normalityTest()).test("lb", niid.ljungBox()).test("bp", niid.boxPierce()).test("seaslb", niid.seasonalLjungBox()).test("seasbp", niid.seasonalBoxPierce()).test("lb2", niid.ljungBoxOnSquare()).test("bp2", niid.boxPierceOnSquare()).test("nruns", niid.runsNumber()).test("lruns", niid.runsLength()).test("nudruns", niid.upAndDownRunsNumbber()).test("ludruns", niid.upAndDownRunsLength()).build();
        return RegSarimaModel.builder().description(desc).estimation(est).residuals(residuals).details(Details.builder().regressionItems(regressionDesc).derivedTradingDay(tdderived).FTestonTradingDays(tdf).build()).build();
    }

    public int getAnnualFrequency() {
        return this.description.getSeries().getAnnualFrequency();
    }

    public SarimaOrders specification() {
        return this.description.getStochasticComponent().orders();
    }

    public SarimaModel arima() {
        return SarimaModel.builder(this.description.getStochasticComponent()).build();
    }

    public RegArimaModel<SarimaModel> regarima() {
        int start;
        Matrix X = this.estimation.getX();
        boolean mean = this.isMeanEstimation();
        RegArimaModel.Builder builder = RegArimaModel.builder().y(this.estimation.getY()).arima(this.arima()).meanCorrection(mean);
        for (int i = start = mean ? 1 : 0; i < X.getColumnsCount(); ++i) {
            builder.addX(X.column(i));
        }
        return builder.build();
    }

    public TsData fullResiduals() {
        return this.residuals.getTsres();
    }

    public int freeArimaParametersCount() {
        return this.description.getStochasticComponent().freeParametersCount();
    }

    public IFunction likelihoodFunction() {
        RegArmaModel<SarimaModel> regarima = this.regarima().differencedModel();
        return RegArmaFunction.builder(regarima.getY()).likelihoodEvaluation(DefaultLikelihoodEvaluation.ml()).variables(regarima.getX()).mapping(this.mapping().stationaryMapping()).missingCount(regarima.getMissingCount()).build();
    }

    public IArimaMapping<SarimaModel> mapping() {
        SarimaSpec arima = this.description.getStochasticComponent();
        if (arima.hasFixedParameters()) {
            int n = arima.getP() + arima.getBp() + arima.getQ() + arima.getBq();
            double[] p = new double[n];
            boolean[] b = new boolean[n];
            int j = 0;
            Parameter[] P = arima.getPhi();
            int i = 0;
            while (i < P.length) {
                p[j] = P[i].getValue();
                b[j] = P[i].isFixed();
                ++i;
                ++j;
            }
            P = arima.getTheta();
            i = 0;
            while (i < P.length) {
                p[j] = P[i].getValue();
                b[j] = P[i].isFixed();
                ++i;
                ++j;
            }
            P = arima.getBtheta();
            i = 0;
            while (i < P.length) {
                p[j] = P[i].getValue();
                b[j] = P[i].isFixed();
                ++i;
                ++j;
            }
            return new SarimaFixedMapping(this.specification(), DoubleSeq.of((double[])p), b);
        }
        return SarimaMapping.of(this.specification());
    }

    public Forecasts forecasts(int nf) {
        String key;
        Forecasts fcasts;
        if (nf < 0) {
            nf = -nf * this.getAnnualFrequency();
        }
        if ((fcasts = (Forecasts)this.cache.get(key = "forecasts" + nf)) == null) {
            fcasts = this.internalForecasts(nf);
            this.cache.put(key, fcasts);
        }
        return fcasts;
    }

    public Forecasts backcasts(int nb) {
        String key;
        Forecasts bcasts;
        if (nb < 0) {
            nb = -nb * this.getAnnualFrequency();
        }
        if ((bcasts = (Forecasts)this.cache.get(key = "backcasts" + nb)) == null) {
            bcasts = this.internalBackcasts(nb);
            this.cache.put(key, bcasts);
        }
        return bcasts;
    }

    public TsData linearizedForecasts(int n) {
        if (n < 0) {
            n = -n * this.getAnnualFrequency();
        }
        TsData lin = this.linearizedSeries();
        ExactArimaForecasts fcast = new ExactArimaForecasts();
        fcast.prepare((IArimaModel)this.arima(), this.isMeanCorrection());
        DoubleSeq f = fcast.forecasts(lin.getValues(), n);
        return TsData.of((TsPeriod)lin.getEnd(), (DoubleSeq)f);
    }

    public TsData linearizedBackcasts(int n) {
        if (n < 0) {
            n = -n * this.getAnnualFrequency();
        }
        TsData lin = this.linearizedSeries();
        ExactArimaForecasts fcast = new ExactArimaForecasts();
        fcast.prepare((IArimaModel)this.arima(), this.isMeanCorrection());
        DoubleSeq f = fcast.backcasts(lin.getValues(), n);
        return TsData.of((TsPeriod)lin.getStart().plus((long)(-n)), (DoubleSeq)f);
    }

    private TsData regY() {
        TsData s = this.transformedSeries();
        TsData preadjust = this.preadjustmentEffect(s.getDomain(), v -> true);
        return TsData.subtract((TsData)s, (TsData)preadjust);
    }

    private Forecasts internalForecasts(int nf) {
        TsData efy;
        RegArimaForecasts.Result fcasts;
        TsDomain dom = this.getDescription().getDomain();
        if (nf == 0) {
            TsData empty = TsData.of((TsPeriod)dom.getEndPeriod(), (DoubleSeq)DoubleSeq.empty());
            return new Forecasts(empty, empty, empty, empty);
        }
        DoubleSeq b = this.getEstimation().getCoefficients();
        LikelihoodStatistics ll = this.getEstimation().getStatistics();
        double sig2 = ll.getSsqErr() / (double)(ll.getEffectiveObservationsCount() - ll.getEstimatedParametersCount());
        TsDomain xdom = dom.extend(0, nf);
        if (b.isEmpty()) {
            fcasts = RegArimaForecasts.calcForecast(this.arima(), this.regY().getValues(), nf, sig2);
        } else {
            FastMatrix matrix = this.regressionMatrix(xdom);
            fcasts = RegArimaForecasts.calcForecast(this.arima(), this.regY().getValues(), (Matrix)matrix, b, this.getEstimation().getCoefficientsCovariance(), sig2);
        }
        TsPeriod fstart = dom.getEndPeriod();
        double[] f = fcasts.getForecasts();
        double[] ef = fcasts.getForecastsStdev();
        TsData tf = TsData.ofInternal((TsPeriod)fstart, (double[])f);
        tf = TsData.add((TsData)tf, (TsData)this.preadjustmentEffect(xdom, v -> true));
        TsData fy = this.backTransform(tf, true);
        if (this.getDescription().isLogTransformation()) {
            double[] e = new double[nf];
            for (int i = 0; i < nf; ++i) {
                e[i] = LogNormal.stdev(f[i], ef[i]);
            }
            efy = TsData.ofInternal((TsPeriod)fstart, (double[])e);
        } else {
            efy = TsData.ofInternal((TsPeriod)fstart, (double[])ef);
        }
        return new Forecasts(TsData.ofInternal((TsPeriod)fstart, (double[])f), TsData.ofInternal((TsPeriod)fstart, (double[])ef), fy, efy);
    }

    private Forecasts internalBackcasts(int nb) {
        TsData eby;
        RegArimaForecasts.Result bcasts;
        TsDomain dom = this.getDescription().getDomain();
        if (nb == 0) {
            TsData empty = TsData.of((TsPeriod)dom.getStartPeriod(), (DoubleSeq)DoubleSeq.empty());
            return new Forecasts(empty, empty, empty, empty);
        }
        DoubleSeq b = this.getEstimation().getCoefficients();
        LikelihoodStatistics ll = this.getEstimation().getStatistics();
        double sig2 = ll.getSsqErr() / (double)(ll.getEffectiveObservationsCount() - ll.getEstimatedParametersCount());
        TsDomain xdom = dom.extend(nb, 0);
        if (b.isEmpty()) {
            bcasts = RegArimaForecasts.calcForecast(this.arima(), this.regY().getValues().reverse(), nb, sig2);
        } else {
            FastMatrix matrix = this.regressionMatrix(xdom);
            FastMatrix rmatrix = FastMatrix.make(matrix.getRowsCount(), matrix.getColumnsCount());
            DataBlockIterator iter = matrix.columnsIterator();
            DataBlockIterator riter = rmatrix.columnsIterator();
            while (iter.hasNext()) {
                riter.next().copy(iter.next().reverse());
            }
            bcasts = RegArimaForecasts.calcForecast(this.arima(), this.regY().getValues().reverse(), (Matrix)matrix, b, this.getEstimation().getCoefficientsCovariance(), sig2);
        }
        TsPeriod bstart = dom.getStartPeriod().plus((long)(-nb));
        double[] f = bcasts.getForecasts();
        double[] ef = bcasts.getForecastsStdev();
        Arrays2.reverse((double[])f);
        Arrays2.reverse((double[])ef);
        TsData tb = TsData.ofInternal((TsPeriod)bstart, (double[])f);
        tb = TsData.add((TsData)tb, (TsData)this.preadjustmentEffect(xdom, v -> true));
        TsData by = this.backTransform(tb, true);
        if (this.getDescription().isLogTransformation()) {
            double[] e = new double[nb];
            for (int i = 0; i < nb; ++i) {
                e[i] = LogNormal.stdev(f[i], ef[i]);
            }
            eby = TsData.ofInternal((TsPeriod)bstart, (double[])e);
        } else {
            eby = TsData.ofInternal((TsPeriod)bstart, (double[])ef);
        }
        return new Forecasts(TsData.ofInternal((TsPeriod)bstart, (double[])f), TsData.ofInternal((TsPeriod)bstart, (double[])ef), by, eby);
    }

    public RegressionItem regressionItem(Predicate<ITsVariable> pred, int item) {
        List<RegressionDesc> items = this.details.getRegressionItems();
        int curitem = 0;
        for (RegressionDesc desc : items) {
            if (!pred.test(desc.getCore())) continue;
            if (item == curitem) {
                return new RegressionItem(desc.getCoef(), desc.getStderr(), desc.getPvalue(), desc.getCore().description(desc.getItem(), (TimeSeriesDomain)this.estimation.getDomain()));
            }
            ++curitem;
        }
        return null;
    }

    public <T extends ITsVariable> int countVariables(Class<T> tclass, boolean fixed) {
        Variable[] variables = this.description.getVariables();
        if (fixed) {
            return Arrays.stream(variables).filter(var -> tclass.isInstance(var.getCore())).mapToInt(var -> var.fixedCoefficientsCount()).sum();
        }
        return Arrays.stream(variables).filter(var -> tclass.isInstance(var.getCore())).mapToInt(var -> var.freeCoefficientsCount()).sum();
    }

    private static DataBlock weights(ITradingDaysVariable var) {
        if (var instanceof GenericTradingDaysVariable) {
            GenericTradingDaysVariable td = (GenericTradingDaysVariable)var;
            return RegSarimaModel.weights(td.getClustering());
        }
        if (var instanceof HolidaysCorrectedTradingDays) {
            HolidaysCorrectedTradingDays td = (HolidaysCorrectedTradingDays)var;
            return RegSarimaModel.weights(td.getClustering());
        }
        return null;
    }

    private static DataBlock weights(DayClustering td) {
        int n = td.getGroupsCount();
        double[] w = new double[n - 1];
        for (int i = 1; i < n; ++i) {
            w[i - 1] = td.getGroupCount(i);
        }
        return DataBlock.of(w);
    }

    @Generated
    RegSarimaModel(Map<String, Object> additionalResults, GeneralLinearModel.Description<SarimaSpec> description, GeneralLinearModel.Estimation estimation, TsResiduals residuals, Details details) {
        this.additionalResults = additionalResults;
        this.description = description;
        this.estimation = estimation;
        this.residuals = residuals;
        this.details = details;
    }

    @Generated
    public static @NonNull Builder builder() {
        return new Builder();
    }

    @Generated
    public ConcurrentMap<String, Object> getCache() {
        return this.cache;
    }

    @Generated
    public Map<String, Object> getAdditionalResults() {
        return this.additionalResults;
    }

    @Override
    @Generated
    public GeneralLinearModel.Description<SarimaSpec> getDescription() {
        return this.description;
    }

    @Override
    @Generated
    public GeneralLinearModel.Estimation getEstimation() {
        return this.estimation;
    }

    @Override
    @Generated
    public TsResiduals getResiduals() {
        return this.residuals;
    }

    @Generated
    public Details getDetails() {
        return this.details;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegSarimaModel)) {
            return false;
        }
        RegSarimaModel other = (RegSarimaModel)o;
        ConcurrentMap<String, Object> this$cache = this.getCache();
        ConcurrentMap<String, Object> other$cache = other.getCache();
        if (this$cache == null ? other$cache != null : !this$cache.equals(other$cache)) {
            return false;
        }
        Map<String, Object> this$additionalResults = this.getAdditionalResults();
        Map<String, Object> other$additionalResults = other.getAdditionalResults();
        if (this$additionalResults == null ? other$additionalResults != null : !((Object)this$additionalResults).equals(other$additionalResults)) {
            return false;
        }
        GeneralLinearModel.Description<SarimaSpec> this$description = this.getDescription();
        GeneralLinearModel.Description<SarimaSpec> other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        GeneralLinearModel.Estimation this$estimation = this.getEstimation();
        GeneralLinearModel.Estimation other$estimation = other.getEstimation();
        if (this$estimation == null ? other$estimation != null : !this$estimation.equals(other$estimation)) {
            return false;
        }
        TsResiduals this$residuals = this.getResiduals();
        TsResiduals other$residuals = other.getResiduals();
        if (this$residuals == null ? other$residuals != null : !this$residuals.equals(other$residuals)) {
            return false;
        }
        Details this$details = this.getDetails();
        Details other$details = other.getDetails();
        return !(this$details == null ? other$details != null : !((Object)this$details).equals(other$details));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConcurrentMap<String, Object> $cache = this.getCache();
        result = result * 59 + ($cache == null ? 43 : $cache.hashCode());
        Map<String, Object> $additionalResults = this.getAdditionalResults();
        result = result * 59 + ($additionalResults == null ? 43 : ((Object)$additionalResults).hashCode());
        GeneralLinearModel.Description<SarimaSpec> $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        GeneralLinearModel.Estimation $estimation = this.getEstimation();
        result = result * 59 + ($estimation == null ? 43 : $estimation.hashCode());
        TsResiduals $residuals = this.getResiduals();
        result = result * 59 + ($residuals == null ? 43 : $residuals.hashCode());
        Details $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : ((Object)$details).hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "RegSarimaModel(cache=" + String.valueOf(this.getCache()) + ", additionalResults=" + String.valueOf(this.getAdditionalResults()) + ", description=" + String.valueOf(this.getDescription()) + ", estimation=" + String.valueOf(this.getEstimation()) + ", residuals=" + String.valueOf(this.getResiduals()) + ", details=" + String.valueOf(this.getDetails()) + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private ArrayList<String> additionalResults$key;
        @Generated
        private ArrayList<Object> additionalResults$value;
        @Generated
        private GeneralLinearModel.Description<SarimaSpec> description;
        @Generated
        private GeneralLinearModel.Estimation estimation;
        @Generated
        private TsResiduals residuals;
        @Generated
        private Details details;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder additionalResult(String additionalResultKey, Object additionalResultValue) {
            if (this.additionalResults$key == null) {
                this.additionalResults$key = new ArrayList();
                this.additionalResults$value = new ArrayList();
            }
            this.additionalResults$key.add(additionalResultKey);
            this.additionalResults$value.add(additionalResultValue);
            return this;
        }

        @Generated
        public @NonNull Builder additionalResults(@NonNull Map<? extends String, ? extends Object> additionalResults) {
            if (additionalResults == null) {
                throw new NullPointerException("additionalResults cannot be null");
            }
            if (this.additionalResults$key == null) {
                this.additionalResults$key = new ArrayList();
                this.additionalResults$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : additionalResults.entrySet()) {
                this.additionalResults$key.add($lombokEntry.getKey());
                this.additionalResults$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public @NonNull Builder clearAdditionalResults() {
            if (this.additionalResults$key != null) {
                this.additionalResults$key.clear();
                this.additionalResults$value.clear();
            }
            return this;
        }

        @Generated
        public @NonNull Builder description(GeneralLinearModel.Description<SarimaSpec> description) {
            this.description = description;
            return this;
        }

        @Generated
        public @NonNull Builder estimation(GeneralLinearModel.Estimation estimation) {
            this.estimation = estimation;
            return this;
        }

        @Generated
        public @NonNull Builder residuals(TsResiduals residuals) {
            this.residuals = residuals;
            return this;
        }

        @Generated
        public @NonNull Builder details(Details details) {
            this.details = details;
            return this;
        }

        @Generated
        public @NonNull RegSarimaModel build() {
            Map<String, Object> additionalResults;
            switch (this.additionalResults$key == null ? 0 : this.additionalResults$key.size()) {
                case 0: {
                    additionalResults = Collections.emptyMap();
                    break;
                }
                case 1: {
                    additionalResults = Collections.singletonMap(this.additionalResults$key.get(0), this.additionalResults$value.get(0));
                    break;
                }
                default: {
                    additionalResults = new LinkedHashMap(this.additionalResults$key.size() < 0x40000000 ? 1 + this.additionalResults$key.size() + (this.additionalResults$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.additionalResults$key.size(); ++$i) {
                        additionalResults.put(this.additionalResults$key.get($i), this.additionalResults$value.get($i));
                    }
                    additionalResults = Collections.unmodifiableMap(additionalResults);
                }
            }
            return new RegSarimaModel(additionalResults, this.description, this.estimation, this.residuals, this.details);
        }

        @Generated
        public @NonNull String toString() {
            return "RegSarimaModel.Builder(additionalResults$key=" + String.valueOf(this.additionalResults$key) + ", additionalResults$value=" + String.valueOf(this.additionalResults$value) + ", description=" + String.valueOf(this.description) + ", estimation=" + String.valueOf(this.estimation) + ", residuals=" + String.valueOf(this.residuals) + ", details=" + String.valueOf(this.details) + ")";
        }
    }

    public static final class Details {
        private final List<RegressionDesc> regressionItems;
        private final RegressionDesc derivedTradingDay;
        private final StatisticalTest FTestonTradingDays;

        @Generated
        Details(List<RegressionDesc> regressionItems, RegressionDesc derivedTradingDay, StatisticalTest FTestonTradingDays) {
            this.regressionItems = regressionItems;
            this.derivedTradingDay = derivedTradingDay;
            this.FTestonTradingDays = FTestonTradingDays;
        }

        @Generated
        public static @NonNull Builder builder() {
            return new Builder();
        }

        @Generated
        public List<RegressionDesc> getRegressionItems() {
            return this.regressionItems;
        }

        @Generated
        public RegressionDesc getDerivedTradingDay() {
            return this.derivedTradingDay;
        }

        @Generated
        public StatisticalTest getFTestonTradingDays() {
            return this.FTestonTradingDays;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Details)) {
                return false;
            }
            Details other = (Details)o;
            List<RegressionDesc> this$regressionItems = this.getRegressionItems();
            List<RegressionDesc> other$regressionItems = other.getRegressionItems();
            if (this$regressionItems == null ? other$regressionItems != null : !((Object)this$regressionItems).equals(other$regressionItems)) {
                return false;
            }
            RegressionDesc this$derivedTradingDay = this.getDerivedTradingDay();
            RegressionDesc other$derivedTradingDay = other.getDerivedTradingDay();
            if (this$derivedTradingDay == null ? other$derivedTradingDay != null : !((Object)this$derivedTradingDay).equals(other$derivedTradingDay)) {
                return false;
            }
            StatisticalTest this$FTestonTradingDays = this.getFTestonTradingDays();
            StatisticalTest other$FTestonTradingDays = other.getFTestonTradingDays();
            return !(this$FTestonTradingDays == null ? other$FTestonTradingDays != null : !this$FTestonTradingDays.equals(other$FTestonTradingDays));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<RegressionDesc> $regressionItems = this.getRegressionItems();
            result = result * 59 + ($regressionItems == null ? 43 : ((Object)$regressionItems).hashCode());
            RegressionDesc $derivedTradingDay = this.getDerivedTradingDay();
            result = result * 59 + ($derivedTradingDay == null ? 43 : ((Object)$derivedTradingDay).hashCode());
            StatisticalTest $FTestonTradingDays = this.getFTestonTradingDays();
            result = result * 59 + ($FTestonTradingDays == null ? 43 : $FTestonTradingDays.hashCode());
            return result;
        }

        @Generated
        public @NonNull String toString() {
            return "RegSarimaModel.Details(regressionItems=" + String.valueOf(this.getRegressionItems()) + ", derivedTradingDay=" + String.valueOf(this.getDerivedTradingDay()) + ", FTestonTradingDays=" + String.valueOf(this.getFTestonTradingDays()) + ")";
        }

        @Generated
        public static class Builder {
            @Generated
            private List<RegressionDesc> regressionItems;
            @Generated
            private RegressionDesc derivedTradingDay;
            @Generated
            private StatisticalTest FTestonTradingDays;

            @Generated
            Builder() {
            }

            @Generated
            public @NonNull Builder regressionItems(List<RegressionDesc> regressionItems) {
                this.regressionItems = regressionItems;
                return this;
            }

            @Generated
            public @NonNull Builder derivedTradingDay(RegressionDesc derivedTradingDay) {
                this.derivedTradingDay = derivedTradingDay;
                return this;
            }

            @Generated
            public @NonNull Builder FTestonTradingDays(StatisticalTest FTestonTradingDays) {
                this.FTestonTradingDays = FTestonTradingDays;
                return this;
            }

            @Generated
            public @NonNull Details build() {
                return new Details(this.regressionItems, this.derivedTradingDay, this.FTestonTradingDays);
            }

            @Generated
            public @NonNull String toString() {
                return "RegSarimaModel.Details.Builder(regressionItems=" + String.valueOf(this.regressionItems) + ", derivedTradingDay=" + String.valueOf(this.derivedTradingDay) + ", FTestonTradingDays=" + String.valueOf(this.FTestonTradingDays) + ")";
            }
        }
    }

    public static final class Forecasts {
        private final TsData rawForecasts;
        private final TsData rawForecastsStdev;
        private final TsData forecasts;
        private final TsData forecastsStdev;

        @Generated
        public Forecasts(TsData rawForecasts, TsData rawForecastsStdev, TsData forecasts, TsData forecastsStdev) {
            this.rawForecasts = rawForecasts;
            this.rawForecastsStdev = rawForecastsStdev;
            this.forecasts = forecasts;
            this.forecastsStdev = forecastsStdev;
        }

        @Generated
        public TsData getRawForecasts() {
            return this.rawForecasts;
        }

        @Generated
        public TsData getRawForecastsStdev() {
            return this.rawForecastsStdev;
        }

        @Generated
        public TsData getForecasts() {
            return this.forecasts;
        }

        @Generated
        public TsData getForecastsStdev() {
            return this.forecastsStdev;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Forecasts)) {
                return false;
            }
            Forecasts other = (Forecasts)o;
            TsData this$rawForecasts = this.getRawForecasts();
            TsData other$rawForecasts = other.getRawForecasts();
            if (this$rawForecasts == null ? other$rawForecasts != null : !this$rawForecasts.equals(other$rawForecasts)) {
                return false;
            }
            TsData this$rawForecastsStdev = this.getRawForecastsStdev();
            TsData other$rawForecastsStdev = other.getRawForecastsStdev();
            if (this$rawForecastsStdev == null ? other$rawForecastsStdev != null : !this$rawForecastsStdev.equals(other$rawForecastsStdev)) {
                return false;
            }
            TsData this$forecasts = this.getForecasts();
            TsData other$forecasts = other.getForecasts();
            if (this$forecasts == null ? other$forecasts != null : !this$forecasts.equals(other$forecasts)) {
                return false;
            }
            TsData this$forecastsStdev = this.getForecastsStdev();
            TsData other$forecastsStdev = other.getForecastsStdev();
            return !(this$forecastsStdev == null ? other$forecastsStdev != null : !this$forecastsStdev.equals(other$forecastsStdev));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TsData $rawForecasts = this.getRawForecasts();
            result = result * 59 + ($rawForecasts == null ? 43 : $rawForecasts.hashCode());
            TsData $rawForecastsStdev = this.getRawForecastsStdev();
            result = result * 59 + ($rawForecastsStdev == null ? 43 : $rawForecastsStdev.hashCode());
            TsData $forecasts = this.getForecasts();
            result = result * 59 + ($forecasts == null ? 43 : $forecasts.hashCode());
            TsData $forecastsStdev = this.getForecastsStdev();
            result = result * 59 + ($forecastsStdev == null ? 43 : $forecastsStdev.hashCode());
            return result;
        }

        @Generated
        public @NonNull String toString() {
            return "RegSarimaModel.Forecasts(rawForecasts=" + String.valueOf(this.getRawForecasts()) + ", rawForecastsStdev=" + String.valueOf(this.getRawForecastsStdev()) + ", forecasts=" + String.valueOf(this.getForecasts()) + ", forecastsStdev=" + String.valueOf(this.getForecastsStdev()) + ")";
        }
    }
}

