/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf;

import jdplus.toolkit.base.core.data.DataBlock;

public class UpdateInformation {
    private Status status;
    private double e;
    private double f;
    private double stde;
    private final DataBlock M;

    public UpdateInformation(int dim) {
        this.M = DataBlock.make(dim);
    }

    public double get() {
        return this.e;
    }

    public double getVariance() {
        return this.f;
    }

    public double getStandardDeviation() {
        return this.stde;
    }

    public DataBlock M() {
        return this.M;
    }

    public void setVariance(double f) {
        this.f = f;
        this.stde = Math.sqrt(f);
    }

    public void setStandardDeviation(double e) {
        this.f = e * e;
        this.stde = e;
    }

    public void set(double val, boolean constraint) {
        this.status = constraint ? Status.CONSTRAINT : Status.OBSERVATION;
        this.e = val;
    }

    public boolean isMissing() {
        return this.status == Status.MISSING;
    }

    public void setMissing() {
        this.e = Double.NaN;
        this.status = Status.MISSING;
        this.M.set(() -> Double.NaN);
    }

    public Status getStatus() {
        return this.status;
    }

    public static enum Status {
        OBSERVATION,
        CONSTRAINT,
        MISSING;

    }
}

