/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.ckms;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.UpdateInformation;
import jdplus.toolkit.base.core.ssf.ckms.CkmsDiffuseInitializer;
import jdplus.toolkit.base.core.ssf.ckms.CkmsFilter;
import jdplus.toolkit.base.core.ssf.ckms.CkmsState;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.ssf.univariate.ISsfData;
import jdplus.toolkit.base.core.ssf.univariate.ISsfError;

public class CkmsInitializer
implements CkmsFilter.IFastFilterInitializer {
    @Override
    public int initializeFilter(CkmsState fstate, UpdateInformation upd, ISsf ssf, ISsfData data) {
        if (!ssf.isTimeInvariant()) {
            return -1;
        }
        if (ssf.initialization().isDiffuse()) {
            return this.initializeDiffuse(fstate, upd, ssf, data);
        }
        return this.initializeStationary(fstate, upd, ssf, data);
    }

    public int initializeStationary(CkmsState fstate, UpdateInformation upd, ISsf ssf, ISsfData data) {
        ISsfDynamics dynamics = ssf.dynamics();
        ISsfLoading loading = ssf.loading();
        ISsfError error = ssf.measurementError();
        ISsfInitialization initialization = ssf.initialization();
        FastMatrix P0 = FastMatrix.square(initialization.getStateDim());
        initialization.Pf0(P0);
        DataBlock m = upd.M();
        loading.ZM(0, P0, m);
        fstate.l.copy(m);
        dynamics.TX(0, fstate.l());
        double f = loading.ZX(0, fstate.l);
        if (error != null) {
            f += error.at(0);
        }
        upd.setVariance(f);
        return 0;
    }

    public int initializeDiffuse(CkmsState fstate, UpdateInformation upd, ISsf ssf, ISsfData data) {
        CkmsDiffuseInitializer initializer = new CkmsDiffuseInitializer();
        return initializer.initializeFilter(fstate, upd, ssf, data);
    }
}

