/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators.factorAnalysis;

import dr.evomodel.continuous.OrderedLatentLiabilityLikelihood;
import dr.inference.model.DiagonalMatrix;
import dr.inference.model.LatentFactorModel;
import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.Parameter;
import dr.inference.operators.GibbsOperator;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import dr.math.distributions.NormalDistribution;

public class LatentFactorLiabilityGibbsOperator
extends SimpleMCMCOperator
implements GibbsOperator {
    LatentFactorModel lfm;
    OrderedLatentLiabilityLikelihood liabilityLikelihood;

    public LatentFactorLiabilityGibbsOperator(double d, LatentFactorModel latentFactorModel, OrderedLatentLiabilityLikelihood orderedLatentLiabilityLikelihood) {
        this.setWeight(d);
        this.lfm = latentFactorModel;
        this.liabilityLikelihood = orderedLatentLiabilityLikelihood;
    }

    @Override
    public String getOperatorName() {
        return "LatentFactorLiabilityGibbsOperator";
    }

    @Override
    public double doOperation() {
        if (this.liabilityLikelihood.getOrdering().booleanValue()) {
            this.doUnorderedOperation();
        } else {
            this.doOrderedOperation();
        }
        return 0.0;
    }

    void doUnorderedOperation() {
        double[] dArray = this.lfm.getLxF();
        DiagonalMatrix diagonalMatrix = (DiagonalMatrix)this.lfm.getColumnPrecision();
        Parameter parameter = this.lfm.getContinuous();
        MatrixParameterInterface matrixParameterInterface = this.lfm.getScaledData();
        for (int i = 0; i < matrixParameterInterface.getColumnDimension(); ++i) {
            int n = 0;
            int[] nArray = this.liabilityLikelihood.getData(i);
            for (int j = 0; j < nArray.length; ++j) {
                int n2;
                double d;
                int n3 = nArray[j];
                Parameter parameter2 = this.liabilityLikelihood.numClasses;
                int n4 = (int)parameter2.getParameterValue(j);
                if (n3 >= n4 && parameter.getParameterValue(n) == 0.0) {
                    d = this.drawTruncatedNormalDistribution(dArray[i * matrixParameterInterface.getRowDimension() + n], diagonalMatrix.getParameterValue(n, n), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
                    matrixParameterInterface.setParameterValue(n, i, d);
                }
                if ((double)n4 == 1.0) {
                    if (parameter.getParameterValue(n) == 0.0) {
                        d = this.drawTruncatedNormalDistribution(dArray[i * matrixParameterInterface.getRowDimension() + n], diagonalMatrix.getParameterValue(n, n), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
                        matrixParameterInterface.setParameterValue(n, i, d);
                    }
                    ++n;
                    continue;
                }
                if ((double)n4 == 2.0) {
                    if (n3 == 0) {
                        d = this.drawTruncatedNormalDistribution(dArray[i * matrixParameterInterface.getRowDimension() + n], diagonalMatrix.getParameterValue(n, n), Double.NEGATIVE_INFINITY, 0.0);
                        matrixParameterInterface.setParameterValue(n, i, d);
                    } else {
                        d = this.drawTruncatedNormalDistribution(dArray[i * matrixParameterInterface.getRowDimension() + n], diagonalMatrix.getParameterValue(n, n), 0.0, Double.POSITIVE_INFINITY);
                        matrixParameterInterface.setParameterValue(n, i, d);
                    }
                    ++n;
                    continue;
                }
                double[] dArray2 = new double[n4];
                dArray2[0] = 0.0;
                if (n3 == 0) {
                    for (n2 = 0; n2 < n4 - 1; ++n2) {
                        matrixParameterInterface.setParameterValue(n + n2, i, this.drawTruncatedNormalDistribution(dArray[i * matrixParameterInterface.getRowDimension() + (n + n2)], diagonalMatrix.getParameterValue(n + n2, n + n2), Double.NEGATIVE_INFINITY, 0.0));
                    }
                } else {
                    dArray2[n3] = this.drawTruncatedNormalDistribution(dArray[i * matrixParameterInterface.getRowDimension() + (n + n3 - 1)], diagonalMatrix.getParameterValue(n + n3 - 1, n + n3 - 1), 0.0, Double.POSITIVE_INFINITY);
                    matrixParameterInterface.setParameterValue(n + n3 - 1, i, dArray2[n3]);
                    for (n2 = 1; n2 < n4; ++n2) {
                        if (n2 == n3) continue;
                        dArray2[n2] = this.drawTruncatedNormalDistribution(dArray[i * matrixParameterInterface.getRowDimension() + (n + n2 - 1)], diagonalMatrix.getParameterValue(n + n2 - 1, n + n2 - 1), Double.NEGATIVE_INFINITY, dArray2[n3]);
                        matrixParameterInterface.setParameterValue(n + n2 - 1, i, dArray2[n2]);
                    }
                }
                n += n4 - 1;
            }
        }
    }

    void doOrderedOperation() {
        double[] dArray = this.lfm.getLxF();
        DiagonalMatrix diagonalMatrix = (DiagonalMatrix)this.lfm.getColumnPrecision();
        Parameter parameter = this.lfm.getContinuous();
        MatrixParameterInterface matrixParameterInterface = this.lfm.getScaledData();
        Parameter parameter2 = this.liabilityLikelihood.getThreshold();
        for (int i = 0; i < matrixParameterInterface.getColumnDimension(); ++i) {
            int n = 0;
            int[] nArray = this.liabilityLikelihood.getData(i);
            for (int j = 0; j < nArray.length; ++j) {
                int n2 = nArray[j];
                Parameter parameter3 = this.liabilityLikelihood.numClasses;
                int n3 = (int)parameter3.getParameterValue(j);
                if (n2 >= n3 && parameter.getParameterValue(j) == 0.0) {
                    double d = this.drawTruncatedNormalDistribution(dArray[i * matrixParameterInterface.getRowDimension() + j], diagonalMatrix.getParameterValue(j, j), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
                    matrixParameterInterface.setParameterValue(j, i, d);
                    continue;
                }
                if ((double)n3 == 1.0) {
                    if (parameter.getParameterValue(j) != 0.0) continue;
                    double d = this.drawTruncatedNormalDistribution(dArray[i * matrixParameterInterface.getRowDimension() + j], diagonalMatrix.getParameterValue(j, j), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
                    matrixParameterInterface.setParameterValue(j, i, d);
                    continue;
                }
                if ((double)n3 == 2.0) {
                    if (n2 == 0) {
                        double d = this.drawTruncatedNormalDistribution(dArray[i * matrixParameterInterface.getRowDimension() + j], diagonalMatrix.getParameterValue(j, j), Double.NEGATIVE_INFINITY, 0.0);
                        matrixParameterInterface.setParameterValue(j, i, d);
                        continue;
                    }
                    double d = this.drawTruncatedNormalDistribution(dArray[i * matrixParameterInterface.getRowDimension() + j], diagonalMatrix.getParameterValue(j, j), 0.0, Double.POSITIVE_INFINITY);
                    matrixParameterInterface.setParameterValue(j, i, d);
                    continue;
                }
                double[] dArray2 = new double[n3 + 1];
                dArray2[0] = Double.NEGATIVE_INFINITY;
                dArray2[1] = 0.0;
                dArray2[n3] = Double.POSITIVE_INFINITY;
                for (int k = 0; k < dArray2.length - 3; ++k) {
                    dArray2[k + 2] = parameter2.getParameterValue(n + k);
                }
                n += n3 - 2;
                double d = this.drawTruncatedNormalDistribution(dArray[i * matrixParameterInterface.getRowDimension() + j], diagonalMatrix.getParameterValue(j, j), dArray2[n2], dArray2[n2 + 1]);
                matrixParameterInterface.setParameterValue(j, i, d);
            }
        }
    }

    double drawTruncatedNormalDistribution(double d, double d2, double d3, double d4) {
        double d5 = Math.sqrt(1.0 / d2);
        NormalDistribution normalDistribution = new NormalDistribution(d, d5);
        double d6 = normalDistribution.cdf(d3);
        double d7 = normalDistribution.cdf(d4);
        double d8 = 1.0;
        boolean bl = true;
        double d9 = 0.0;
        for (int i = 0; i < 10000 && bl; ++i) {
            d8 = MathUtils.nextDouble() * (d7 - d6) + d6;
            d9 = normalDistribution.quantile(d8);
            if (Double.isNaN(d9) || !(d9 > d3) || !(d9 < d4)) continue;
            bl = false;
        }
        if (Double.isNaN(d9) || Double.isInfinite(d9)) {
            if (Double.isInfinite(d3)) {
                return d4;
            }
            if (Double.isInfinite(d4)) {
                return d3;
            }
            return (d3 + d4) / 2.0;
        }
        return d9;
    }
}

