# License for `ChileDataAPI`

This package, `ChileDataAPI`, is licensed under the **GNU General Public License Version 3 (GPL-3)**.

You are free to:

- Use, modify, and distribute the package, as long as any modifications or derived works also comply with the GPL-3.
- Distribute copies of this package with attribution, keeping this license intact.

## License Text

The full text of the GNU General Public License Version 3 (GPL-3) can be found [here](https://www.gnu.org/licenses/gpl-3.0.txt).

## Note on FINDIC and REST Countries

The `ChileDataAPI` package depends on two public RESTful APIs for accessing Chilean and global data:

1. **FINDIC**
A public Chilean API that provides programmatic access to official financial and economic indicators of Chile.
It allows querying time series of various indicators such as the observed dollar exchange rate, inflation (CPI), interest rates, stock market values, and more.
The project's goal is to facilitate fast and reliable access to key economic data of the country, encouraging its use in financial analysis, academic research, and educational applications.
The API delivers up-to-date data directly from official sources such as the Central Bank of Chile and other relevant institutions.
Website: [https://findic.cl](https://findic.cl)
Terms of Use: The API is publicly accessible, does not require authentication, and is intended for educational, analytical, and experimental purposes.


2. **REST Countries API**  
   An open-source project that offers information about countries worldwide, including demographics, geography, and regional groupings.  
   This API is also publicly accessible and does not require authentication.  
   Website: [https://restcountries.com/](https://restcountries.com/)

As per the maintainers of both APIs, **no attribution is required** for using or distributing the data.  
However, we recommend reviewing the official documentation and usage terms on their respective websites to ensure proper understanding and responsible use.

## Note

The `ChileDataAPI` package, including all its data files (.rda) and code files, is licensed under the GNU General Public License, version 3 or later (GPL-3).

## Copyright Notice

© 2025 Renzo Caceres Rossi. All rights reserved under the GPL-3.
