/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.check.checkers;

import org.ohdsi.circe.check.WarningSeverity;
import org.ohdsi.circe.check.checkers.BaseCorelatedCriteriaCheck;
import org.ohdsi.circe.check.checkers.WarningReporter;
import org.ohdsi.circe.check.operations.Operations;
import org.ohdsi.circe.cohortdefinition.CorelatedCriteria;

public class OcurrenceCheck
extends BaseCorelatedCriteriaCheck {
    private static final String AT_LEAST_0_WARNING = "'at least 0' occurrence is not a real constraint, probably meant 'exactly 0' or 'at least 1'";
    private static final int AT_LEAST = 2;

    @Override
    protected WarningSeverity defineSeverity() {
        return WarningSeverity.WARNING;
    }

    @Override
    protected void checkCriteria(CorelatedCriteria criteria, String groupName, WarningReporter reporter) {
        Operations.match(criteria.occurrence).when(o -> 2 == o.type && 0 == o.count).then(() -> reporter.add(AT_LEAST_0_WARNING, new Object[0]));
    }
}

