/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.algorithm.niching;

import java.util.List;
import net.sourceforge.jclec.IIndividual;
import net.sourceforge.jclec.algorithm.niching.SpatialNiching;
import net.sourceforge.jclec.fitness.IValueFitness;
import net.sourceforge.jclec.fitness.SimpleValueFitness;
import org.apache.commons.configuration.Configuration;

public class Sharing
extends SpatialNiching {
    private static final long serialVersionUID = -3565568784140690740L;
    protected double alpha;
    protected double[] shDistances;

    public final double getAlpha() {
        return this.alpha;
    }

    public final void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    @Override
    public void configure(Configuration configuration) {
        super.configure(configuration);
        double alpha = configuration.getDouble("alpha");
        this.setAlpha(alpha);
    }

    @Override
    protected void createNiches() {
        double radiusOfNiche = this.calculateRadiusNiche(this.bset);
        this.shDistances = this.calculateFitnessSharing(this.bset, radiusOfNiche);
        for (IIndividual ind : this.bset) {
            IIndividual individual = ind.copy();
            individual.setFitness(ind.getFitness().copy());
            this.nset.add(individual);
        }
        int i = 0;
        for (IIndividual ind : this.nset) {
            if (this.shDistances[i] != 0.0) {
                double valor = ((IValueFitness)ind.getFitness()).getValue() / this.shDistances[i];
                ((SimpleValueFitness)ind.getFitness()).setValue(valor);
            }
            ++i;
        }
    }

    protected double[] calculateFitnessSharing(List<IIndividual> actpop, double radiusOfNiche) {
        double[] shDistance = new double[actpop.size()];
        double auxShDistance = 0.0;
        int i = 0;
        while (i < actpop.size()) {
            shDistance[i] = 0.0;
            int j = 0;
            while (j < actpop.size()) {
                double distance;
                auxShDistance = i != j ? ((distance = actpop.get(i).distance(actpop.get(j))) < radiusOfNiche ? 1.0 - Math.pow(distance / radiusOfNiche, this.alpha) : 0.0) : 0.0;
                int n = i;
                shDistance[n] = shDistance[n] + auxShDistance;
                ++j;
            }
            ++i;
        }
        return shDistance;
    }

    public double calculateRadiusNiche(List<IIndividual> inds) {
        double maximumDistance = -1.0;
        int i = 0;
        while (i < inds.size()) {
            int j = i + 1;
            while (j < inds.size()) {
                if (maximumDistance < inds.get(i).distance(inds.get(j))) {
                    maximumDistance = inds.get(i).distance(inds.get(j));
                }
                ++j;
            }
            ++i;
        }
        return 0.2 * maximumDistance;
    }
}

