/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.automata.fast_regular;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.model.constraints.automaton.FA.IAutomaton;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.global.automata.common.StoredIndexedBipartiteSetWithOffset;
import choco.kernel.solver.constraints.global.automata.fast_regular.structure.Arc;
import choco.kernel.solver.constraints.global.automata.fast_regular.structure.Node;
import choco.kernel.solver.constraints.global.automata.fast_regular.structure.StoredDirectedMultiGraph;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.propagation.event.ConstraintEvent;
import choco.kernel.solver.variables.integer.IntDomainVar;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import gnu.trove.TIntStack;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import org.jgrapht.graph.DirectedMultigraph;

public class FastRegular
extends AbstractLargeIntSConstraint {
    StoredDirectedMultiGraph graph;
    TIntStack temp = new TIntStack();

    public FastRegular(IEnvironment environment, IntDomainVar[] vars, IAutomaton auto) {
        super(ConstraintEvent.LINEAR, vars);
        int k;
        TIntIterator layerIter;
        int j;
        DisposableIntIterator varIter;
        int i;
        int aid = 0;
        int nid = 0;
        int[] offsets = new int[vars.length];
        int[] sizes = new int[vars.length];
        int[] starts = new int[vars.length];
        int totalSizes = 0;
        starts[0] = 0;
        for (int i2 = 0; i2 < vars.length; ++i2) {
            offsets[i2] = vars[i2].getInf();
            sizes[i2] = vars[i2].getSup() - vars[i2].getInf() + 1;
            if (i2 > 0) {
                starts[i2] = sizes[i2 - 1] + starts[i2 - 1];
            }
            totalSizes += sizes[i2];
        }
        int n = vars.length;
        DirectedMultigraph<Node, Arc> graph = new DirectedMultigraph<Node, Arc>(new Arc.ArcFacroty());
        ArrayList tmp = new ArrayList(totalSizes);
        for (i = 0; i < totalSizes; ++i) {
            tmp.add(new HashSet());
        }
        ArrayList<TIntHashSet> layer = new ArrayList<TIntHashSet>();
        TIntHashSet[] tmpQ = new TIntHashSet[totalSizes];
        for (i = 0; i <= n; ++i) {
            layer.add(new TIntHashSet());
        }
        ((TIntHashSet)layer.get(0)).add(auto.getInitialState());
        TIntHashSet nexts = new TIntHashSet();
        for (i = 0; i < n; ++i) {
            varIter = vars[i].getDomain().getIterator();
            while (varIter.hasNext()) {
                j = varIter.next();
                layerIter = ((TIntHashSet)layer.get(i)).iterator();
                while (layerIter.hasNext()) {
                    k = layerIter.next();
                    nexts.clear();
                    auto.delta(k, j, nexts);
                    TIntIterator it = nexts.iterator();
                    while (it.hasNext()) {
                        int succ = it.next();
                        ((TIntHashSet)layer.get(i + 1)).add(succ);
                    }
                    if (nexts.isEmpty()) continue;
                    int idx = starts[i] + j - offsets[i];
                    if (tmpQ[idx] == null) {
                        tmpQ[idx] = new TIntHashSet();
                    }
                    tmpQ[idx].add(k);
                }
            }
            varIter.dispose();
        }
        layerIter = ((TIntHashSet)layer.get(n)).iterator();
        while (layerIter.hasNext()) {
            k = layerIter.next();
            if (auto.isFinal(k)) continue;
            layerIter.remove();
        }
        int nbNodes = auto.getNbStates();
        BitSet mark = new BitSet(nbNodes);
        Node[] in = new Node[auto.getNbStates() * (n + 1)];
        for (i = n - 1; i >= 0; --i) {
            mark.clear(0, nbNodes);
            varIter = vars[i].getDomain().getIterator();
            while (varIter.hasNext()) {
                j = varIter.next();
                int idx = starts[i] + j - offsets[i];
                TIntHashSet l = tmpQ[idx];
                if (l == null) continue;
                TIntIterator qijIter = l.iterator();
                while (qijIter.hasNext()) {
                    k = qijIter.next();
                    nexts.clear();
                    auto.delta(k, j, nexts);
                    boolean added = false;
                    TIntIterator it = nexts.iterator();
                    while (it.hasNext()) {
                        Node b;
                        int qn = it.next();
                        if (!((TIntHashSet)layer.get(i + 1)).contains(qn)) continue;
                        added = true;
                        Node a = in[i * auto.getNbStates() + k];
                        if (a == null) {
                            in[i * auto.getNbStates() + k] = a = new Node(k, i, nid++);
                            graph.addVertex(a);
                        }
                        if ((b = in[(i + 1) * auto.getNbStates() + qn]) == null) {
                            in[(i + 1) * auto.getNbStates() + qn] = b = new Node(qn, i + 1, nid++);
                            graph.addVertex(b);
                        }
                        Arc arc = new Arc(a, b, j, aid++);
                        graph.addEdge(a, b, arc);
                        ((HashSet)tmp.get(idx)).add(arc);
                        mark.set(k);
                    }
                    if (added) continue;
                    qijIter.remove();
                }
            }
            varIter.dispose();
            layerIter = ((TIntHashSet)layer.get(i)).iterator();
            while (layerIter.hasNext()) {
                if (mark.get(layerIter.next())) continue;
                layerIter.remove();
            }
        }
        this.graph = new StoredDirectedMultiGraph(environment, this, graph, starts, offsets, totalSizes);
    }

    @Override
    public void awakeOnRem(int i, int j) throws ContradictionException {
        StoredIndexedBipartiteSetWithOffset sup = this.graph.getSupport(i, j);
        if (sup != null) {
            int arcId;
            DisposableIntIterator it = sup.getIterator();
            while (it.hasNext()) {
                arcId = it.next();
                this.temp.push(arcId);
            }
            it.dispose();
            while (this.temp.size() > 0) {
                arcId = this.temp.pop();
                try {
                    this.graph.removeArc(arcId);
                }
                catch (ContradictionException e) {
                    this.temp.clear();
                    throw e;
                }
            }
        }
    }

    @Override
    public void propagate() throws ContradictionException {
    }

    @Override
    public void awake() throws ContradictionException {
        for (int i = 0; i < ((IntDomainVar[])this.vars).length; ++i) {
            int right = Integer.MIN_VALUE;
            int left = Integer.MIN_VALUE;
            int j = ((IntDomainVar[])this.vars)[i].getInf();
            while (j <= ((IntDomainVar[])this.vars)[i].getSup()) {
                StoredIndexedBipartiteSetWithOffset sup = this.graph.getSupport(i, j);
                if (sup == null || sup.isEmpty()) {
                    if (j == right + 1) {
                        right = j;
                    } else {
                        ((IntDomainVar[])this.vars)[i].removeInterval(left, right, this, false);
                        left = right = j;
                    }
                }
                j = ((IntDomainVar[])this.vars)[i].getNextDomainValue(j);
            }
            ((IntDomainVar[])this.vars)[i].removeInterval(left, right, this, false);
        }
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 4;
    }
}

