/*
 * Decompiled with CFR 0.152.
 */
package dr.evoxml;

import dr.evolution.util.Units;
import dr.evoxml.util.DateUnitsType;
import dr.evoxml.util.XMLUnits;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.StringAttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import dr.xml.XORRule;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;

public class DateParser
extends AbstractXMLObjectParser {
    public static final String VALUE = "value";
    public static final String UNITS = "units";
    public static final String ORIGIN = "origin";
    public static final String DIRECTION = "direction";
    public static final String FORWARDS = DateUnitsType.FORWARDS.getAttribute();
    public static final String BACKWARDS = DateUnitsType.BACKWARDS.getAttribute();
    public static final String YEARS = DateUnitsType.YEARS.getAttribute();
    public static final String MONTHS = DateUnitsType.MONTHS.getAttribute();
    public static final String DAYS = DateUnitsType.DAYS.getAttribute();
    public static final String UNCERTAINTY = "uncertainty";
    public static final String PRECISION = "precision";
    private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new StringAttributeRule("value", "The value of this date"), new StringAttributeRule("origin", "The origin of this time scale, which must be a valid calendar date", "01/01/01", true), new StringAttributeRule("units", "The units of the timescale", new String[]{YEARS, MONTHS, DAYS}, true), new StringAttributeRule("direction", "The direction of the timescale", new String[]{FORWARDS, BACKWARDS}, true), new XORRule(AttributeRule.newDoubleRule("uncertainty", false, "The uncertainty to which the date is specified"), AttributeRule.newDoubleRule("precision", false, "The uncertainty to which the date is specified"), true)};

    @Override
    public String getParserName() {
        return "date";
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        dr.evolution.util.Date date;
        Object object;
        DateFormat dateFormat = DateFormat.getDateInstance(3, Locale.UK);
        dateFormat.setLenient(true);
        if (xMLObject.getChildCount() > 0) {
            throw new XMLParseException("No child elements allowed in date element.");
        }
        double d = 0.0;
        Date date2 = null;
        if (xMLObject.hasAttribute(VALUE)) {
            try {
                d = xMLObject.getDoubleAttribute(VALUE);
            }
            catch (XMLParseException xMLParseException) {
                object = xMLObject.getStringAttribute(VALUE);
                try {
                    date2 = dateFormat.parse((String)object);
                }
                catch (Exception exception) {
                    throw new XMLParseException("value=" + (String)object + " not recognised as a date, use DD/MM/YYYY");
                }
            }
        } else {
            throw new XMLParseException("Value attribute missing from date element.");
        }
        boolean bl = false;
        if (xMLObject.hasAttribute(DIRECTION) && ((String)(object = (String)xMLObject.getAttribute(DIRECTION))).equals(BACKWARDS)) {
            bl = true;
        }
        object = XMLUnits.Utils.getUnitsAttr(xMLObject);
        if (xMLObject.hasAttribute(ORIGIN)) {
            Date date3;
            String string = (String)xMLObject.getAttribute(ORIGIN);
            try {
                date3 = dateFormat.parse(string);
            }
            catch (Exception exception) {
                throw new XMLParseException("origin=" + string + " not recognised as a date, use DD/MM/YYYY");
            }
            date = date2 != null ? new dr.evolution.util.Date(date2, (Units.Type)((Object)object), date3) : new dr.evolution.util.Date(d, (Units.Type)((Object)object), bl, date3);
        } else {
            date = date2 != null ? new dr.evolution.util.Date(date2, (Units.Type)((Object)object)) : new dr.evolution.util.Date(d, (Units.Type)((Object)object), bl);
        }
        if (xMLObject.hasAttribute(UNCERTAINTY)) {
            double d2 = xMLObject.getDoubleAttribute(UNCERTAINTY);
            date.setUncertainty(d2);
        } else if (xMLObject.hasAttribute(PRECISION)) {
            double d3 = xMLObject.getDoubleAttribute(PRECISION);
            date.setUncertainty(d3);
        }
        return date;
    }

    @Override
    public String getParserDescription() {
        return "Specifies a date on a given timescale";
    }

    @Override
    public String getExample() {
        return "<!-- a date representing 10 years in the past                                 -->\n<date value=\"10.0\" units=\"years\" direction=\"backwards\"/>\n\n<!-- a date representing 300 days after Jan 1st 1989                          -->\n<date value=\"300.0\" origin=\"01/01/89\" units=\"days\" direction=\"forwards\"/>\n";
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }

    @Override
    public Class getReturnType() {
        return dr.evolution.util.Date.class;
    }
}

