/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.substmodel;

import dr.evolution.datatype.DataType;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.oldevomodel.substmodel.AbstractSubstitutionModel;
import dr.oldevomodel.substmodel.FrequencyModel;

public class MutationDeathModel
extends AbstractSubstitutionModel {
    private AbstractSubstitutionModel CTMCModel;
    private Parameter delParameter = null;
    protected double[] trMatrix;
    private Parameter baseSubModelFreq;
    private Parameter thisSubModelFreq;
    private Parameter mutationRate;

    public MutationDeathModel(Parameter parameter, DataType dataType, AbstractSubstitutionModel abstractSubstitutionModel, FrequencyModel frequencyModel, Parameter parameter2) {
        super("mutationDeathModel", dataType, frequencyModel);
        int n;
        this.CTMCModel = abstractSubstitutionModel;
        this.stateCount = frequencyModel.getFrequencyCount();
        this.delParameter = parameter;
        this.dataType = dataType;
        this.mutationRate = parameter2;
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.addVariable(parameter2);
        if (abstractSubstitutionModel != null) {
            this.addModel(abstractSubstitutionModel.getFrequencyModel());
            this.addModel(abstractSubstitutionModel);
        }
        this.trMatrix = new double[(this.stateCount - 1) * (this.stateCount - 1)];
        this.baseSubModelFreq = this.CTMCModel != null ? this.CTMCModel.getFrequencyModel().getFrequencyParameter() : new Parameter.Default(new double[]{1.0});
        this.thisSubModelFreq = this.getFrequencyModel().getFrequencyParameter();
        double d = 0.0;
        for (n = 0; n < this.baseSubModelFreq.getDimension(); ++n) {
            double d2 = this.thisSubModelFreq.getParameterValue(n);
            d += d2;
            this.baseSubModelFreq.setParameterValue(n, d2);
        }
        for (n = 0; n < this.baseSubModelFreq.getDimension(); ++n) {
            this.baseSubModelFreq.setParameterValue(n, this.baseSubModelFreq.getParameterValue(n) / d);
        }
        this.thisSubModelFreq.setParameterValue(this.thisSubModelFreq.getDimension() - 1, 0.0);
        this.copyFrequencies();
        this.frequenciesChanged();
        this.ratesChanged();
        this.setupRelativeRates();
    }

    public Parameter getDeathParameter() {
        return this.delParameter;
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (object == this.baseSubModelFreq) {
            this.copyFrequencies();
            this.fireModelChanged(object, n);
        } else if (model == this.CTMCModel) {
            this.fireModelChanged(object, n);
        }
    }

    private void copyFrequencies() {
        for (int i = 0; i < this.baseSubModelFreq.getDimension(); ++i) {
            this.thisSubModelFreq.setParameterValueQuietly(i, this.baseSubModelFreq.getParameterValue(i));
        }
    }

    @Override
    protected void frequenciesChanged() {
    }

    @Override
    protected void ratesChanged() {
    }

    @Override
    protected void setupRelativeRates() {
    }

    @Override
    public void getTransitionProbabilities(double d, double[] dArray) {
        int n;
        int n2;
        double d2 = Math.exp(-d * this.delParameter.getParameterValue(0));
        double d3 = 2.0 * this.mutationRate.getParameterValue(0);
        double[] dArray2 = this.freqModel.getFrequencyParameter().getParameterValues();
        for (n2 = 0; n2 < dArray2.length - 1; ++n2) {
            d3 *= dArray2[n2];
        }
        if (this.CTMCModel != null) {
            this.CTMCModel.getTransitionProbabilities(d3 * d, this.trMatrix);
        } else {
            this.trMatrix[0] = 1.0;
        }
        for (n2 = 0; n2 < this.stateCount - 1; ++n2) {
            for (n = 0; n < this.stateCount - 1; ++n) {
                dArray[n2 * this.stateCount + n] = this.trMatrix[n2 * (this.stateCount - 1) + n] * d2;
            }
            dArray[n2 * this.stateCount + n] = 1.0 - d2;
        }
        for (n = 0; n < this.stateCount - 1; ++n) {
            dArray[this.stateCount * (this.stateCount - 1) + n] = 0.0;
        }
        dArray[this.stateCount * this.stateCount - 1] = 1.0;
    }
}

