/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.x11;

import ec.satoolkit.x11.IEndPointsProcessor;
import ec.satoolkit.x11.IFiltering;
import ec.satoolkit.x11.StableSeasonalFilteringStrategy;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.linearfilters.SymmetricFilter;
import ec.tstoolkit.timeseries.simplets.PeriodIterator;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;

public class DefaultSeasonalFilteringStrategy
implements IFiltering {
    SymmetricFilter filter;
    IEndPointsProcessor endPointsProcessor;
    private String description_;

    public void setDescription(String desc) {
        this.description_ = desc;
    }

    @Override
    public String getDescription() {
        return this.description_ == null ? "" : this.description_;
    }

    public DefaultSeasonalFilteringStrategy(SymmetricFilter filter, IEndPointsProcessor endPoints) {
        this.filter = filter;
        this.endPointsProcessor = endPoints;
    }

    public DefaultSeasonalFilteringStrategy(SymmetricFilter filter, IEndPointsProcessor endPoints, String desc) {
        this.filter = filter;
        this.endPointsProcessor = endPoints;
        this.description_ = desc;
    }

    private TsData compositeProcess(TsData s, TsDomain rdomain) {
        TsData out = new TsData(rdomain);
        PeriodIterator pin = new PeriodIterator(s, rdomain);
        PeriodIterator pout = new PeriodIterator(out);
        int nf = this.filter.getUpperBound();
        while (pin.hasMoreElements()) {
            DataBlock bin = pin.nextElement().data;
            DataBlock bout = pout.nextElement().data;
            int len = bin.getLength();
            if (2 * nf < len) {
                this.filter.filter(bin, bout.drop(nf, nf));
                this.endPointsProcessor.process(bin, bout);
                continue;
            }
            this.endPointsProcessor.process(bin, bout);
        }
        return out;
    }

    @Override
    public SymmetricFilter getCentralFilter() {
        return this.filter;
    }

    @Override
    public TsData process(TsData s, TsDomain domain) {
        int nyr;
        TsDomain rdomain = domain == null ? s.getDomain() : domain;
        int ny = rdomain.getLength() / rdomain.getFrequency().intValue();
        int n = nyr = rdomain.getLength() % rdomain.getFrequency().intValue() == 0 ? ny : ny + 1;
        if (ny < 5 || nyr < 20 && this.filter.getDegree() >= 8) {
            return new StableSeasonalFilteringStrategy().process(s, rdomain);
        }
        if (this.endPointsProcessor == null) {
            return this.simpleProcess(s, rdomain);
        }
        return this.compositeProcess(s, rdomain);
    }

    private TsData simpleProcess(TsData s, TsDomain rdomain) {
        int nf = this.filter.getLength();
        int freq = rdomain.getFrequency().intValue();
        int nout = rdomain.getLength() - (nf - 1) * freq;
        TsData out = new TsData(rdomain.getStart().minus(this.filter.getLowerBound() * freq), nout);
        PeriodIterator pin = new PeriodIterator(s, rdomain);
        PeriodIterator pout = new PeriodIterator(out);
        while (pin.hasMoreElements()) {
            DataBlock bin = pin.nextElement().data;
            DataBlock bout = pout.nextElement().data;
            this.filter.filter(bin, bout);
        }
        return out;
    }
}

