/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.List;
import org.jgrapht.Graph;
import org.jgrapht.alg.BellmanFordIterator;
import org.jgrapht.alg.BellmanFordPathElement;

public class BellmanFordShortestPath<V, E> {
    private static final double DEFAULT_EPSILON = 1.0E-9;
    protected Graph<V, E> graph;
    protected V startVertex;
    private BellmanFordIterator<V, E> iter;
    private int nMaxHops;
    private int passNumber;
    private double epsilon;

    public BellmanFordShortestPath(Graph<V, E> graph, V v) {
        this(graph, v, graph.vertexSet().size() - 1);
    }

    public BellmanFordShortestPath(Graph<V, E> graph, V v, int n) {
        this(graph, v, n, 1.0E-9);
    }

    public BellmanFordShortestPath(Graph<V, E> graph, V v, int n, double d) {
        this.startVertex = v;
        this.nMaxHops = n;
        this.graph = graph;
        this.passNumber = 1;
        this.epsilon = d;
    }

    public double getCost(V v) {
        this.assertGetPath(v);
        this.lazyCalculate();
        BellmanFordPathElement<V, E> bellmanFordPathElement = this.iter.getPathElement(v);
        if (bellmanFordPathElement == null) {
            return Double.POSITIVE_INFINITY;
        }
        return bellmanFordPathElement.getCost();
    }

    public List<E> getPathEdgeList(V v) {
        this.assertGetPath(v);
        this.lazyCalculate();
        BellmanFordPathElement<V, E> bellmanFordPathElement = this.iter.getPathElement(v);
        if (bellmanFordPathElement == null) {
            return null;
        }
        return bellmanFordPathElement.createEdgeListPath();
    }

    private void assertGetPath(V v) {
        if (v.equals(this.startVertex)) {
            throw new IllegalArgumentException("The end vertex is the same as the start vertex!");
        }
        if (!this.graph.containsVertex(v)) {
            throw new IllegalArgumentException("Graph must contain the end vertex!");
        }
    }

    private void lazyCalculate() {
        if (this.iter == null) {
            this.iter = new BellmanFordIterator<V, E>(this.graph, this.startVertex, this.epsilon);
        }
        while (this.passNumber <= this.nMaxHops && this.iter.hasNext()) {
            this.iter.next();
            ++this.passNumber;
        }
    }

    public static <V, E> List<E> findPathBetween(Graph<V, E> graph, V v, V v2) {
        BellmanFordShortestPath<V, E> bellmanFordShortestPath = new BellmanFordShortestPath<V, E>(graph, v);
        return bellmanFordShortestPath.getPathEdgeList(v2);
    }
}

