/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import opennlp.tools.util.ObjectStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectorySampleStream
implements ObjectStream<File> {
    private final List<File> inputDirectories;
    private final boolean isRecursiveScan;
    private final FileFilter fileFilter;
    private Stack<File> directories = new Stack();
    private Stack<File> textFiles = new Stack();

    public DirectorySampleStream(File[] dirs, FileFilter fileFilter, boolean recursive) {
        this.fileFilter = fileFilter;
        this.isRecursiveScan = recursive;
        ArrayList<File> inputDirectoryList = new ArrayList<File>(dirs.length);
        for (File dir : dirs) {
            if (!dir.isDirectory()) {
                throw new IllegalArgumentException("All passed in directories must be directories, but \"" + dir.toString() + "\" is not!");
            }
            inputDirectoryList.add(dir);
        }
        this.inputDirectories = Collections.unmodifiableList(inputDirectoryList);
        this.directories.addAll(this.inputDirectories);
    }

    public DirectorySampleStream(File dir, FileFilter fileFilter, boolean recursive) {
        this(new File[]{dir}, fileFilter, recursive);
    }

    @Override
    public File read() throws IOException {
        while (this.textFiles.isEmpty() && !this.directories.isEmpty()) {
            File dir = this.directories.pop();
            File[] files = this.fileFilter != null ? dir.listFiles(this.fileFilter) : dir.listFiles();
            for (File file : files) {
                if (file.isFile()) {
                    this.textFiles.push(file);
                    continue;
                }
                if (!this.isRecursiveScan || !file.isDirectory()) continue;
                this.directories.push(file);
            }
        }
        if (!this.textFiles.isEmpty()) {
            return this.textFiles.pop();
        }
        return null;
    }

    @Override
    public void reset() {
        this.directories.clear();
        this.textFiles.clear();
        this.directories.addAll(this.inputDirectories);
    }

    @Override
    public void close() throws IOException {
    }
}

