## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)
# Suppress vignette title mismatch warning
options(rmarkdown.html_vignette.check_title = FALSE)

## ----setup, message=FALSE, warning=FALSE--------------------------------------
library(pipetime)
library(dplyr)

## -----------------------------------------------------------------------------
slow_op <- function(x) {
  Sys.sleep(0.1)  # Simulate a time-consuming operation
  x^2
}

## ----error=TRUE---------------------------------------------------------------
try({
# Must wrap the entire pipeline, breaking the flow
the_time <- system.time({
  df <- data.frame(x = 1:3) |>
    mutate(y = slow_op(x)) |>
    summarise(mean_y = mean(y))
})
the_time
df

# system.time() cannot be inserted inline in a pipeline:
data.frame(x = 1:3) |>
  mutate(y = slow_op(x)) |>
  # system.time() would break the pipeline here
  summarise(mean_y = mean(y))
})

## -----------------------------------------------------------------------------
library(tictoc)

# Requires manual start/stop
tic("total pipeline")
df <- data.frame(x = 1:3) |>
  mutate(y = slow_op(x)) |>
  summarise(mean_y = mean(y))
toc()
df

## -----------------------------------------------------------------------------
# Inline timing checkpoints, pipeline stays intact
data.frame(x = 1:3) |>
  mutate(y = slow_op(x)) |>
  time_pipe("after mutate") |>
  summarise(mean_y = mean(y)) |>
  time_pipe("total pipeline")


