/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.selectors.values;

import java.util.OptionalInt;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.chocosolver.solver.Cause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.ResolutionPolicy;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperator;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperatorFactory;
import org.chocosolver.solver.search.strategy.selectors.values.IntDomainMin;
import org.chocosolver.solver.search.strategy.selectors.values.IntValueSelector;
import org.chocosolver.solver.variables.IntVar;

public final class IntDomainBest
implements IntValueSelector,
Function<IntVar, OptionalInt> {
    private final int maxdom;
    private final DecisionOperator<IntVar> dop;
    private final BiPredicate<IntVar, Integer> condition;
    private final IntValueSelector fallbackValueSelector;
    private final Function<IntVar, Boolean> trigger;

    public IntDomainBest(int maxdom, IntValueSelector intValueSelector, Function<IntVar, Boolean> trigger, DecisionOperator<IntVar> dop, BiPredicate<IntVar, Integer> condition) {
        this.maxdom = maxdom;
        this.dop = dop;
        this.condition = condition;
        this.fallbackValueSelector = intValueSelector;
        this.trigger = trigger;
    }

    public IntDomainBest(IntValueSelector intValueSelector, Function<IntVar, Boolean> trigger) {
        this(100, intValueSelector, trigger, DecisionOperatorFactory.makeIntEq(), (k, v) -> false);
    }

    public IntDomainBest(BiPredicate<IntVar, Integer> condition) {
        this(100, new IntDomainMin(), v -> true, DecisionOperatorFactory.makeIntEq(), condition);
    }

    public IntDomainBest() {
        this(100, new IntDomainMin(), v -> true, DecisionOperatorFactory.makeIntEq(), (k, v) -> false);
    }

    @Override
    public int selectValue(IntVar var) {
        if (!this.trigger.apply(var).booleanValue()) {
            return this.fallbackValueSelector.selectValue(var);
        }
        assert (var.getModel().getObjective() != null);
        return this.getBestValue(var);
    }

    @Override
    public OptionalInt apply(IntVar var) {
        if (!this.trigger.apply(var).booleanValue()) {
            return OptionalInt.empty();
        }
        assert (var.getModel().getObjective() != null);
        return OptionalInt.of(this.getBestValue(var));
    }

    private int getBestValue(IntVar var) {
        int ubB;
        if (var.hasEnumeratedDomain() && var.getDomainSize() < this.maxdom) {
            int bestCost = Integer.MAX_VALUE;
            int ub = var.getUB();
            int bestV = this.dop == DecisionOperatorFactory.makeIntReverseSplit() ? ub : var.getLB();
            int v = var.getLB();
            while (v <= ub) {
                int bound = this.bound(var, v);
                if (bound < bestCost || bound == bestCost && this.condition.test(var, v)) {
                    bestCost = bound;
                    bestV = v;
                }
                v = var.nextValue(v);
            }
            return bestV;
        }
        int lbB = this.bound(var, var.getLB());
        if (lbB == (ubB = this.bound(var, var.getUB()))) {
            return this.dop == DecisionOperatorFactory.makeIntReverseSplit() ? var.getUB() : var.getLB();
        }
        return lbB < ubB ? var.getLB() : var.getUB();
    }

    private int bound(IntVar var, int val) {
        int cost;
        Model model = var.getModel();
        if (this.dop == DecisionOperatorFactory.makeIntSplit() && val == var.getUB() || this.dop == DecisionOperatorFactory.makeIntReverseSplit() && val == var.getLB()) {
            return Integer.MAX_VALUE;
        }
        model.getSolver().pushTrail();
        try {
            this.dop.apply(var, val, Cause.Null);
            model.getSolver().getEngine().propagate();
            ResolutionPolicy rp = model.getSolver().getObjectiveManager().getPolicy();
            cost = rp == ResolutionPolicy.SATISFACTION ? 1 : (rp == ResolutionPolicy.MINIMIZE ? ((IntVar)model.getObjective()).getLB() : -((IntVar)model.getObjective()).getUB());
        }
        catch (ContradictionException cex) {
            cost = Integer.MAX_VALUE;
        }
        model.getSolver().getEngine().flush();
        model.getSolver().cancelTrail();
        return cost;
    }
}

