/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling.regression;

import java.util.HashMap;
import java.util.Map;
import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsException;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.regression.AdditiveOutlier;
import jdplus.toolkit.base.api.timeseries.regression.Constant;
import jdplus.toolkit.base.api.timeseries.regression.EasterVariable;
import jdplus.toolkit.base.api.timeseries.regression.GenericTradingDaysVariable;
import jdplus.toolkit.base.api.timeseries.regression.HolidaysCorrectedTradingDays;
import jdplus.toolkit.base.api.timeseries.regression.HolidaysVariable;
import jdplus.toolkit.base.api.timeseries.regression.ITsVariable;
import jdplus.toolkit.base.api.timeseries.regression.InterventionVariable;
import jdplus.toolkit.base.api.timeseries.regression.JulianEasterVariable;
import jdplus.toolkit.base.api.timeseries.regression.LengthOfPeriod;
import jdplus.toolkit.base.api.timeseries.regression.LevelShift;
import jdplus.toolkit.base.api.timeseries.regression.LinearTrend;
import jdplus.toolkit.base.api.timeseries.regression.ModifiedTsVariable;
import jdplus.toolkit.base.api.timeseries.regression.MovingHolidayVariable;
import jdplus.toolkit.base.api.timeseries.regression.PeriodicContrasts;
import jdplus.toolkit.base.api.timeseries.regression.PeriodicDummies;
import jdplus.toolkit.base.api.timeseries.regression.PeriodicOutlier;
import jdplus.toolkit.base.api.timeseries.regression.Ramp;
import jdplus.toolkit.base.api.timeseries.regression.StockTradingDays;
import jdplus.toolkit.base.api.timeseries.regression.SwitchOutlier;
import jdplus.toolkit.base.api.timeseries.regression.TransitoryChange;
import jdplus.toolkit.base.api.timeseries.regression.TrendConstant;
import jdplus.toolkit.base.api.timeseries.regression.TrigonometricVariables;
import jdplus.toolkit.base.api.timeseries.regression.TsVariable;
import jdplus.toolkit.base.api.timeseries.regression.TsVariables;
import jdplus.toolkit.base.api.timeseries.regression.UserMovingHoliday;
import jdplus.toolkit.base.api.timeseries.regression.UserTradingDays;
import jdplus.toolkit.base.api.timeseries.regression.UserVariable;
import jdplus.toolkit.base.api.timeseries.regression.UserVariables;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixWindow;
import jdplus.toolkit.base.core.modelling.regression.AOFactory;
import jdplus.toolkit.base.core.modelling.regression.ConstantFactory;
import jdplus.toolkit.base.core.modelling.regression.EasterFactory;
import jdplus.toolkit.base.core.modelling.regression.GenericTradingDaysFactory;
import jdplus.toolkit.base.core.modelling.regression.HolidaysCorrectionFactory;
import jdplus.toolkit.base.core.modelling.regression.HolidaysFactory;
import jdplus.toolkit.base.core.modelling.regression.IVFactory;
import jdplus.toolkit.base.core.modelling.regression.JulianEasterFactory;
import jdplus.toolkit.base.core.modelling.regression.LPFactory;
import jdplus.toolkit.base.core.modelling.regression.LSFactory;
import jdplus.toolkit.base.core.modelling.regression.LinearTrendFactory;
import jdplus.toolkit.base.core.modelling.regression.ModifiedTsVariableFactory;
import jdplus.toolkit.base.core.modelling.regression.MovingHolidayFactory;
import jdplus.toolkit.base.core.modelling.regression.PeriodicContrastsFactory;
import jdplus.toolkit.base.core.modelling.regression.PeriodicDummiesFactory;
import jdplus.toolkit.base.core.modelling.regression.RampFactory;
import jdplus.toolkit.base.core.modelling.regression.RegressionVariableFactory;
import jdplus.toolkit.base.core.modelling.regression.SOFactory;
import jdplus.toolkit.base.core.modelling.regression.StockTDFactory;
import jdplus.toolkit.base.core.modelling.regression.TCFactory;
import jdplus.toolkit.base.core.modelling.regression.TrendConstantFactory;
import jdplus.toolkit.base.core.modelling.regression.TrigonometricVariablesFactory;
import jdplus.toolkit.base.core.modelling.regression.TsVariableFactory;
import jdplus.toolkit.base.core.modelling.regression.TsVariablesFactory;
import jdplus.toolkit.base.core.modelling.regression.WOFactory;
import lombok.Generated;
import lombok.NonNull;

public final class Regression {
    private static final Map<Class<? extends ITsVariable>, RegressionVariableFactory> FACTORIES;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V extends ITsVariable, W extends V> boolean register(Class<W> wclass, RegressionVariableFactory<V> factory) {
        Map<Class<? extends ITsVariable>, RegressionVariableFactory> map = FACTORIES;
        synchronized (map) {
            if (FACTORIES.containsKey(wclass)) {
                return false;
            }
            FACTORIES.put(wclass, factory);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V extends ITsVariable> boolean unregister(Class<V> vclass) {
        Map<Class<? extends ITsVariable>, RegressionVariableFactory> map = FACTORIES;
        synchronized (map) {
            RegressionVariableFactory removed = FACTORIES.remove(vclass);
            return removed != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RegressionVariableFactory factoryFor(ITsVariable var) {
        Map<Class<? extends ITsVariable>, RegressionVariableFactory> map = FACTORIES;
        synchronized (map) {
            return FACTORIES.get(var.getClass());
        }
    }

    public static <D extends TimeSeriesDomain> FastMatrix matrix(@NonNull D domain, ITsVariable ... vars) {
        if (domain == null) {
            throw new NullPointerException("domain is marked non-null but is null");
        }
        if (vars == null) {
            throw new NullPointerException("vars is marked non-null but is null");
        }
        return Regression.matrix(domain, null, vars);
    }

    public static <D extends TimeSeriesDomain> FastMatrix matrix(@NonNull D domain, ProcessingLog log, ITsVariable ... vars) {
        if (domain == null) {
            throw new NullPointerException("domain is marked non-null but is null");
        }
        if (vars == null) {
            throw new NullPointerException("vars is marked non-null but is null");
        }
        if (domain.isEmpty() || vars.length == 0) {
            return FastMatrix.EMPTY;
        }
        int nvars = ITsVariable.dim((ITsVariable[])vars);
        int nobs = domain.length();
        FastMatrix M = FastMatrix.make(nobs, nvars);
        MatrixWindow wnd = M.left(0);
        if (domain instanceof TsDomain) {
            TsDomain tsDomain = (TsDomain)domain;
            TsPeriod start = tsDomain.getStartPeriod();
            for (int i = 0; i < vars.length; ++i) {
                ITsVariable v = vars[i];
                RegressionVariableFactory factory = FACTORIES.get(v.getClass());
                if (factory == null) {
                    throw new TsException("Unknown variable");
                }
                factory.fill(v, start, wnd.hnext(v.dim()), log);
            }
        } else {
            boolean j = false;
            for (int i = 0; i < vars.length; ++i) {
                ITsVariable v = vars[i];
                RegressionVariableFactory factory = FACTORIES.get(v.getClass());
                if (factory == null) {
                    throw new TsException("Unknown variable");
                }
                factory.fill(v, domain, wnd.hnext(v.dim()));
            }
        }
        return M;
    }

    public static <D extends TimeSeriesDomain> DataBlock x(@NonNull D domain, @NonNull ITsVariable vars) {
        if (domain == null) {
            throw new NullPointerException("domain is marked non-null but is null");
        }
        if (vars == null) {
            throw new NullPointerException("vars is marked non-null but is null");
        }
        if (vars.dim() != 1) {
            throw new IllegalArgumentException();
        }
        FastMatrix m = Regression.matrix(domain, vars);
        return DataBlock.of(m.getStorage());
    }

    @Generated
    private Regression() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Map<Class<? extends ITsVariable>, RegressionVariableFactory> map = FACTORIES = new HashMap<Class<? extends ITsVariable>, RegressionVariableFactory>();
        synchronized (map) {
            FACTORIES.put(Constant.class, ConstantFactory.FACTORY);
            FACTORIES.put(LinearTrend.class, LinearTrendFactory.FACTORY);
            FACTORIES.put(TrendConstant.class, TrendConstantFactory.FACTORY);
            FACTORIES.put(AdditiveOutlier.class, AOFactory.FACTORY);
            FACTORIES.put(LevelShift.class, LSFactory.FACTORY);
            FACTORIES.put(TransitoryChange.class, TCFactory.FACTORY);
            FACTORIES.put(SwitchOutlier.class, WOFactory.FACTORY);
            FACTORIES.put(PeriodicOutlier.class, SOFactory.FACTORY);
            FACTORIES.put(LengthOfPeriod.class, LPFactory.FACTORY);
            FACTORIES.put(GenericTradingDaysVariable.class, GenericTradingDaysFactory.FACTORY);
            FACTORIES.put(HolidaysCorrectedTradingDays.class, HolidaysCorrectionFactory.FACTORY);
            FACTORIES.put(StockTradingDays.class, StockTDFactory.FACTORY);
            FACTORIES.put(HolidaysVariable.class, HolidaysFactory.FACTORY);
            FACTORIES.put(EasterVariable.class, EasterFactory.FACTORY);
            FACTORIES.put(JulianEasterVariable.class, JulianEasterFactory.FACTORY);
            FACTORIES.put(MovingHolidayVariable.class, MovingHolidayFactory.FACTORY);
            FACTORIES.put(Ramp.class, RampFactory.FACTORY);
            FACTORIES.put(InterventionVariable.class, IVFactory.FACTORY);
            FACTORIES.put(PeriodicDummies.class, PeriodicDummiesFactory.FACTORY);
            FACTORIES.put(PeriodicContrasts.class, PeriodicContrastsFactory.FACTORY);
            FACTORIES.put(TrigonometricVariables.class, TrigonometricVariablesFactory.FACTORY);
            FACTORIES.put(TsVariable.class, TsVariableFactory.FACTORY);
            FACTORIES.put(UserVariable.class, TsVariableFactory.FACTORY);
            FACTORIES.put(UserMovingHoliday.class, TsVariableFactory.FACTORY);
            FACTORIES.put(TsVariables.class, TsVariablesFactory.FACTORY);
            FACTORIES.put(UserVariables.class, TsVariablesFactory.FACTORY);
            FACTORIES.put(UserTradingDays.class, TsVariablesFactory.FACTORY);
            FACTORIES.put(ModifiedTsVariable.class, ModifiedTsVariableFactory.FACTORY);
        }
    }
}

