/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regarima;

import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.regsarima.regular.IRegressionTest;
import jdplus.toolkit.base.core.stats.likelihood.ConcentratedLikelihoodWithMissing;

public class DerivedRegressionTest
implements IRegressionTest {
    private final double tsig;
    private double vcur;
    private double tcur;
    private final boolean ml;

    public DerivedRegressionTest(double tsig, boolean ml) {
        this.tsig = tsig;
        this.ml = ml;
    }

    public double getValue() {
        return this.vcur;
    }

    public double getTStat() {
        return this.tcur;
    }

    @Override
    public boolean accept(ConcentratedLikelihoodWithMissing ll, int nhp, int ireg, int nregs) {
        this.vcur = -ll.coefficients().extract(ireg, nregs).sum();
        FastMatrix V = FastMatrix.of((Matrix)ll.unscaledCovariance().extract(ireg, nregs, ireg, nregs));
        int ndf = this.ml ? ll.dim() : ll.degreesOfFreedom() - nhp;
        double ssq = ll.ssq();
        double v = V.sum() * ssq / (double)ndf;
        this.tcur = this.vcur / Math.sqrt(v);
        return Math.abs(this.tcur) > this.tsig;
    }
}

