/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.substmodel;

import dr.evolution.datatype.TwoStateCovarion;
import dr.inference.model.Parameter;
import dr.oldevomodel.substmodel.AbstractSubstitutionModel;
import dr.oldevomodel.substmodel.FrequencyModel;
import dr.oldevomodel.substmodel.SubstitutionModelUtils;

public class TwoStateCovarionModel
extends AbstractSubstitutionModel {
    private Parameter alpha;
    private Parameter switchingParameter;
    private boolean isNormalized = true;

    public TwoStateCovarionModel(TwoStateCovarion twoStateCovarion, FrequencyModel frequencyModel, Parameter parameter, Parameter parameter2) {
        super("covarionModel", twoStateCovarion, frequencyModel);
        this.alpha = parameter;
        this.switchingParameter = parameter2;
        this.addVariable(this.alpha);
        this.addVariable(parameter2);
        this.setupRelativeRates();
    }

    @Override
    protected void frequenciesChanged() {
    }

    @Override
    protected void ratesChanged() {
        this.setupRelativeRates();
    }

    @Override
    protected void setupRelativeRates() {
        this.relativeRates[0] = this.alpha.getParameterValue(0);
        this.relativeRates[1] = this.switchingParameter.getParameterValue(0);
        this.relativeRates[2] = 0.0;
        this.relativeRates[3] = 0.0;
        this.relativeRates[4] = this.switchingParameter.getParameterValue(0);
        this.relativeRates[5] = 1.0;
    }

    @Override
    public String toString() {
        return SubstitutionModelUtils.toString(this.relativeRates, this.dataType, true, 2);
    }

    @Override
    void normalize(double[][] dArray, double[] dArray2) {
        if (this.isNormalized) {
            int n;
            double d = 0.0;
            int n2 = dArray2.length;
            for (n = 0; n < n2; ++n) {
                d += -dArray[n][n] * dArray2[n];
            }
            for (n = 0; n < n2; ++n) {
                for (int i = 0; i < n2; ++i) {
                    dArray[n][i] = dArray[n][i] / d;
                }
            }
            double d2 = 0.0;
            d2 += dArray[0][2] * dArray2[2];
            d2 += dArray[2][0] * dArray2[0];
            d2 += dArray[1][3] * dArray2[3];
            d2 += dArray[3][1] * dArray2[1];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n2; ++j) {
                    dArray[i][j] = dArray[i][j] / (1.0 - d2);
                }
            }
        }
    }
}

