/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.coalescent;

import jebl.evolution.coalescent.DemographicFunction;

public class ConstantPopulation
implements DemographicFunction {
    private double N0;

    public ConstantPopulation() {
    }

    public ConstantPopulation(double N0) {
        this.N0 = N0;
    }

    public double getN0() {
        return this.N0;
    }

    public void setN0(double N0) {
        this.N0 = N0;
    }

    public double getDemographic(double t) {
        return this.getN0();
    }

    public double getIntensity(double t) {
        return t / this.getN0();
    }

    public double getInverseIntensity(double x) {
        return this.getN0() * x;
    }

    public boolean hasIntegral() {
        return true;
    }

    public double getIntegral(double start, double finish) {
        return this.getIntensity(finish) - this.getIntensity(start);
    }

    public int getArgumentCount() {
        return 1;
    }

    public String getArgumentName(int n) {
        return "N0";
    }

    public double getArgument(int n) {
        return this.getN0();
    }

    public void setArgument(int n, double value) {
        this.setN0(value);
    }

    public double getLowerBound(int n) {
        return 0.0;
    }

    public double getUpperBound(int n) {
        return Double.POSITIVE_INFINITY;
    }
}

