/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;
import javax.swing.text.DefaultCaret;

public class ProgressBar
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private JProgressBar progressBar;
    private JButton startButton;
    private JTextArea taskOutput;

    public ProgressBar(int max) {
        super(new BorderLayout());
        this.progressBar = new JProgressBar(0, max);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.taskOutput = new JTextArea(5, 20);
        this.taskOutput.setMargin(new Insets(5, 5, 5, 5));
        this.taskOutput.setEditable(false);
        JPanel panel = new JPanel();
        panel.add(this.progressBar);
        DefaultCaret caret = (DefaultCaret)this.taskOutput.getCaret();
        caret.setUpdatePolicy(2);
        this.add((Component)panel, "First");
        this.add((Component)new JScrollPane(this.taskOutput), "Center");
        this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
    }

    public void change(int k) {
        int progress = k;
        this.progressBar.setValue(progress);
    }

    public void print(int k, String message) {
        this.taskOutput.append(message);
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
    }

    class Task
    extends SwingWorker<Void, Void> {
        Task() {
        }

        @Override
        public Void doInBackground() {
            Random random = new Random();
            int progress = 0;
            this.setProgress(0);
            while (progress < 100) {
                try {
                    Thread.sleep(random.nextInt(1000));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.setProgress(Math.min(progress += random.nextInt(10), 100));
            }
            return null;
        }

        @Override
        public void done() {
            Toolkit.getDefaultToolkit().beep();
            ProgressBar.this.startButton.setEnabled(true);
            ProgressBar.this.setCursor(null);
            ProgressBar.this.taskOutput.append("Done!\n");
        }
    }
}

