/*
 * Decompiled with CFR 0.152.
 */
package ec.benchmarking.ssf;

import ec.benchmarking.BaseDisaggregation;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IDataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.data.SubArrayOfInt;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.maths.realfunctions.IParametricMapping;
import ec.tstoolkit.maths.realfunctions.ParamValidation;
import ec.tstoolkit.maths.realfunctions.SingleParameter;
import ec.tstoolkit.ssf.ISsf;

public class SsfChowLin
extends BaseDisaggregation
implements ISsf {
    private double ro_;

    public SsfChowLin() {
    }

    public SsfChowLin(int conv) {
        super(conv);
    }

    public SsfChowLin(int conv, double ro) {
        super(conv);
        this.ro_ = ro;
    }

    @Override
    public void diffuseConstraints(SubMatrix b) {
    }

    @Override
    public void fullQ(int pos, SubMatrix qm) {
        qm.set(1, 1, 1.0);
    }

    @Override
    public int getNonStationaryDim() {
        return 0;
    }

    public double getRo() {
        return this.ro_;
    }

    @Override
    public int getStateDim() {
        return 2;
    }

    @Override
    public int getTransitionResCount() {
        return 1;
    }

    @Override
    public int getTransitionResDim() {
        return 1;
    }

    @Override
    public boolean hasR() {
        return true;
    }

    @Override
    public boolean hasTransitionRes(int pos) {
        return true;
    }

    @Override
    public boolean hasW() {
        return false;
    }

    @Override
    public boolean isDiffuse() {
        return false;
    }

    @Override
    public boolean isMeasurementEquationTimeInvariant() {
        return false;
    }

    @Override
    public boolean isTimeInvariant() {
        return false;
    }

    @Override
    public boolean isTransitionEquationTimeInvariant() {
        return false;
    }

    @Override
    public boolean isTransitionResidualTimeInvariant() {
        return true;
    }

    @Override
    public boolean isValid() {
        return Math.abs(this.ro_) < 1.0;
    }

    @Override
    public void L(int pos, DataBlock k, SubMatrix lm) {
        if ((pos + 1) % this.conversion == 0) {
            lm.set(0, 0, -k.get(0));
            lm.set(0, 1, -k.get(0));
            lm.set(1, 0, -k.get(1));
        } else if (pos % this.conversion == 0) {
            lm.set(0, 1, 1.0 - k.get(0));
        } else {
            lm.set(0, 0, 1.0 - k.get(0));
            lm.set(0, 1, -k.get(0));
            lm.set(1, 0, 1.0 - k.get(1));
        }
        lm.set(1, 1, this.ro_ - k.get(1));
    }

    @Override
    public void Pf0(SubMatrix pf0) {
        pf0.set(1, 1, 1.0 / (1.0 - this.ro_ * this.ro_));
    }

    @Override
    public void Pi0(SubMatrix pi0) {
    }

    @Override
    public void Q(int pos, SubMatrix qm) {
        qm.set(0, 0, 1.0);
    }

    @Override
    public void R(int pos, SubArrayOfInt rv) {
        rv.set(0, 1);
    }

    public void setRo(double value) {
        this.ro_ = value;
    }

    @Override
    public void T(int pos, SubMatrix tr) {
        tr.set(1, 1, this.ro_);
        if ((pos + 1) % this.conversion != 0) {
            tr.set(0, 1, 1.0);
            if (pos % this.conversion != 0) {
                tr.set(0, 0, 1.0);
            }
        }
    }

    @Override
    public void TVT(int pos, SubMatrix vm) {
        if ((pos + 1) % this.conversion == 0) {
            vm.set(0, 0, 0.0);
            vm.set(0, 1, 0.0);
            vm.set(1, 0, 0.0);
        } else if (pos % this.conversion == 0) {
            double v = vm.get(1, 1);
            vm.set(0, 0, v);
            vm.set(0, 1, v *= this.ro_);
            vm.set(1, 0, v);
        } else {
            double v11 = vm.get(1, 1);
            double v01 = vm.get(0, 1);
            vm.add(0, 0, 2.0 * v01 + v11);
            double v = this.ro_ * (v01 + v11);
            vm.set(0, 1, v);
            vm.set(1, 0, v);
        }
        vm.mul(1, 1, this.ro_ * this.ro_);
    }

    @Override
    public void TX(int pos, DataBlock x) {
        if ((pos + 1) % this.conversion == 0) {
            x.set(0, 0.0);
        } else if (pos % this.conversion == 0) {
            x.set(0, x.get(1));
        } else {
            x.add(0, x.get(1));
        }
        x.mul(1, this.ro_);
    }

    @Override
    public void VpZdZ(int pos, SubMatrix vm, double d) {
        if (pos % this.conversion == 0) {
            vm.add(1, 1, d);
        } else {
            vm.add(d);
        }
    }

    @Override
    public void W(int pos, SubMatrix wv) {
    }

    @Override
    public void XpZd(int pos, DataBlock x, double d) {
        x.add(1, d);
        if (pos % this.conversion != 0) {
            x.add(0, d);
        }
    }

    @Override
    public void XT(int pos, DataBlock x) {
        if ((pos + 1) % this.conversion == 0) {
            x.set(0, 0.0);
            x.mul(1, this.ro_);
        } else if (pos % this.conversion == 0) {
            x.set(1, x.get(1) * this.ro_ + x.get(0));
            x.set(0, 0.0);
        } else {
            x.set(1, x.get(1) * this.ro_ + x.get(0));
        }
    }

    @Override
    public void Z(int pos, DataBlock z) {
        z.set(1, 1.0);
        if (pos % this.conversion != 0) {
            z.set(0, 1.0);
        }
    }

    @Override
    public void ZM(int pos, SubMatrix m, DataBlock x) {
        x.copy(m.row(1));
        if (pos % this.conversion != 0) {
            x.add(m.row(0));
        }
    }

    @Override
    public double ZVZ(int pos, SubMatrix vm) {
        if (pos % this.conversion == 0) {
            return vm.get(1, 1);
        }
        return vm.sum();
    }

    @Override
    public double ZX(int pos, DataBlock x) {
        if (pos % this.conversion == 0) {
            return x.get(1);
        }
        return x.sum();
    }

    public static class Mapper
    implements IParametricMapping<SsfChowLin> {
        public static final String RHO = "rho";
        public final int conversion;
        public static final double BOUND = 0.999999;
        public static final double EPS = 5.0E-7;

        public Mapper(int conv) {
            this.conversion = conv;
        }

        @Override
        public boolean checkBoundaries(IReadDataBlock inparams) {
            double p = inparams.get(0);
            return p > -0.999999 && p < 0.999999;
        }

        @Override
        public double epsilon(IReadDataBlock inparams, int idx) {
            return inparams.get(0) > 0.0 ? -2.5E-7 : 2.5E-7;
        }

        @Override
        public int getDim() {
            return 1;
        }

        @Override
        public double lbound(int idx) {
            return -0.999999;
        }

        @Override
        public SsfChowLin map(IReadDataBlock p) {
            if (p.getLength() != 1) {
                return null;
            }
            return new SsfChowLin(this.conversion, p.get(0));
        }

        @Override
        public IReadDataBlock map(SsfChowLin t) {
            return new SingleParameter(t.ro_);
        }

        @Override
        public double ubound(int idx) {
            return 0.999999;
        }

        @Override
        public ParamValidation validate(IDataBlock ioparams) {
            double p = ioparams.get(0);
            ParamValidation rslt = ParamValidation.Valid;
            if (p <= -0.999999) {
                p = -0.999999;
                ioparams.set(0, p);
                rslt = ParamValidation.Changed;
            } else if (p >= 0.999999) {
                p = 0.999999;
                ioparams.set(0, p);
                rslt = ParamValidation.Changed;
            }
            return rslt;
        }

        @Override
        public String getDescription(int idx) {
            return RHO;
        }
    }
}

