/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.search.integer;

import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.integer.AbstractIntSConstraint;
import choco.kernel.solver.search.integer.HeuristicIntVarSelector;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.ArrayList;
import java.util.List;

public abstract class DoubleHeuristicIntVarSelector
extends HeuristicIntVarSelector {
    public DoubleHeuristicIntVarSelector(Solver solver) {
        super(solver);
    }

    public DoubleHeuristicIntVarSelector(Solver solver, IntDomainVar[] vars) {
        super(solver, vars);
    }

    public abstract double getHeuristic(IntDomainVar var1);

    public final double getHeuristic(AbstractIntSConstraint c, int i) {
        return this.getHeuristic((IntDomainVar)c.getVar(i));
    }

    @Override
    public final IntDomainVar getMinVar(List<IntDomainVar> vars) {
        double minValue = Double.POSITIVE_INFINITY;
        IntDomainVar v0 = null;
        for (IntDomainVar v : vars) {
            double val;
            if (v.isInstantiated() || !((val = this.getHeuristic(v)) < minValue)) continue;
            minValue = val;
            v0 = v;
        }
        return v0;
    }

    @Override
    public final IntDomainVar getMinVar(IntDomainVar[] vars) {
        double minValue = Double.POSITIVE_INFINITY;
        IntDomainVar v0 = null;
        for (IntDomainVar v : vars) {
            double val;
            if (v.isInstantiated() || !((val = this.getHeuristic(v)) < minValue)) continue;
            minValue = val;
            v0 = v;
        }
        return v0;
    }

    @Override
    public final List<IntDomainVar> getAllMinVars(IntDomainVar[] vars) {
        ArrayList<IntDomainVar> res = new ArrayList<IntDomainVar>();
        double minValue = Double.POSITIVE_INFINITY;
        for (IntDomainVar v : vars) {
            if (v.isInstantiated()) continue;
            double val = this.getHeuristic(v);
            if (val < minValue) {
                res.clear();
                res.add(v);
                minValue = val;
                continue;
            }
            if (val != minValue) continue;
            res.add(v);
        }
        return res;
    }

    @Override
    public final List<IntDomainVar> getAllMinVars(AbstractIntSConstraint c) {
        ArrayList<IntDomainVar> res = new ArrayList<IntDomainVar>();
        double minValue = Double.POSITIVE_INFINITY;
        for (int i = 0; i < c.getNbVars(); ++i) {
            IntDomainVar v = (IntDomainVar)c.getVar(i);
            if (v.isInstantiated()) continue;
            double val = this.getHeuristic(v);
            if (val < minValue) {
                res.clear();
                res.add(v);
                minValue = val;
                continue;
            }
            if (val != minValue) continue;
            res.add(v);
        }
        return res;
    }

    @Override
    public final IntDomainVar getMinVar(AbstractIntSConstraint c) {
        double minValue = Double.POSITIVE_INFINITY;
        IntDomainVar v0 = null;
        for (int i = 0; i < c.getNbVars(); ++i) {
            double val;
            IntDomainVar v = (IntDomainVar)c.getVar(i);
            if (v.isInstantiated() || !((val = this.getHeuristic(c, i)) < minValue)) continue;
            minValue = val;
            v0 = v;
        }
        return v0;
    }
}

