/*
 * Decompiled with CFR 0.152.
 */
package io.github.crew102.rapidrake.opennlpUtils;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSTaggerME;

public class Tagger {
    private String taggerModelUrl;
    private InputStream taggerStream;

    public Tagger(String taggerModelUrl) {
        this.taggerModelUrl = taggerModelUrl;
    }

    public Tagger(InputStream taggerStream) {
        this.taggerStream = taggerStream;
    }

    public POSTaggerME getPosTagger() throws IOException {
        POSModel modelIn;
        InputStream inStream = this.taggerStream;
        try {
            if (this.taggerModelUrl != null) {
                inStream = new FileInputStream(this.taggerModelUrl);
            }
            modelIn = new POSModel(inStream);
        }
        catch (IOException ex) {
            throw new IOException("Couldn't find POS model based on URL", ex);
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException ex2) {
                    throw new IOException(ex2);
                }
            }
        }
        return new POSTaggerME(modelIn);
    }
}

