/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.cnf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.nary.cnf.ILogical;
import org.chocosolver.solver.constraints.nary.cnf.LogOp;
import org.chocosolver.solver.variables.BoolVar;

public class LogicTreeToolBox {
    protected LogicTreeToolBox() {
    }

    public static ILogical toCNF(LogOp logOp, Model model) {
        LogicTreeToolBox.expandNot(logOp);
        logOp = LogicTreeToolBox.distribute(logOp);
        if (logOp.is(LogOp.Operator.OR)) {
            LogicTreeToolBox.sort(logOp);
        }
        ILogical[] children = logOp.getChildren();
        for (int i = 0; i < children.length; ++i) {
            LogOp nc;
            if (children[i].isLit() || !(nc = (LogOp)children[i]).is(LogOp.Operator.OR)) continue;
            LogicTreeToolBox.sort(nc);
        }
        ILogical l = LogicTreeToolBox.simplify(logOp, model);
        l = LogicTreeToolBox.simplifySingleton(l, model);
        if (!(l = LogicTreeToolBox.orderAndReduce(l)).isLit()) {
            ((LogOp)l).cleanFlattenBoolVar();
        }
        return l;
    }

    public static void expandNot(LogOp n) {
        if (n.isNot()) {
            n.flip();
        }
        ILogical[] children = n.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (children[i].isLit()) continue;
            LogicTreeToolBox.expandNot((LogOp)children[i]);
        }
    }

    public static void merge(LogOp.Operator op, LogOp n) {
        if (n.is(op)) {
            ILogical[] children = n.getChildren();
            for (int i = 0; i < children.length; ++i) {
                LogOp nc;
                ILogical child = children[i];
                if (child.isLit() || !(nc = (LogOp)child).is(op)) continue;
                LogicTreeToolBox.merge(op, nc);
                ILogical[] subchildren = nc.getChildren();
                n.removeChild(child);
                for (int j = 0; j < subchildren.length; ++j) {
                    n.addChild(subchildren[j]);
                }
            }
        }
    }

    public static LogOp developOr(LogOp n) {
        ILogical t1 = n.getAndChild();
        ILogical t2 = n.getChildBut(t1);
        LogOp tt = LogOp.and(new ILogical[0]);
        if (t1 == null || !t1.isLit()) {
            LogOp n1 = (LogOp)t1;
            ILogical[] t1cs = n1.getChildren();
            for (int i = 0; i < t1cs.length; ++i) {
                ILogical t1c = t1cs[i];
                if (t2 == null) continue;
                if (t2.isLit()) {
                    tt.addChild(LogOp.or(t1c, t2));
                    continue;
                }
                ILogical[] t2cs = ((LogOp)t2).getChildren();
                for (int j = 0; j < t2cs.length; ++j) {
                    ILogical t2c = t2cs[j];
                    tt.addChild(LogOp.or(t1c, t2c));
                }
            }
        }
        n.removeChild(t1);
        n.removeChild(t2);
        if (n.getNbChildren() == 0) {
            return tt;
        }
        n.addChild(tt);
        return n;
    }

    public static LogOp distribute(LogOp n) {
        if (n.is(LogOp.Operator.AND)) {
            ILogical[] children = n.getChildren();
            for (int i = 0; i < children.length; ++i) {
                if (children[i].isLit()) continue;
                children[i] = LogicTreeToolBox.distribute((LogOp)children[i]);
            }
        } else {
            if (n.hasOrChild()) {
                LogicTreeToolBox.merge(LogOp.Operator.OR, n);
            }
            if (n.hasAndChild() && n.getNbChildren() > 1) {
                n = LogicTreeToolBox.distribute(LogicTreeToolBox.developOr(n));
            }
        }
        LogicTreeToolBox.merge(LogOp.Operator.AND, n);
        return n;
    }

    private static BoolVar[] extract(ILogical node) {
        if (node.isLit()) {
            return new BoolVar[]{(BoolVar)node};
        }
        return ((LogOp)node).flattenBoolVar();
    }

    public static ILogical simplify(ILogical t, Model model) {
        if (t.isLit()) {
            return t;
        }
        LogOp n = (LogOp)t;
        ILogical[] children = n.getChildren();
        if (n.is(LogOp.Operator.OR)) {
            HashMap<BoolVar, ILogical> lits = new HashMap<BoolVar, ILogical>();
            for (int i = 0; i < children.length; ++i) {
                BoolVar var = LogicTreeToolBox.extract(children[i])[0];
                BoolVar boolVar = var = var.isNot() ? var.not() : var;
                if (lits.containsKey(var)) {
                    ILogical prev = (ILogical)lits.get(var);
                    if (prev.isNot() == children[i].isNot()) continue;
                    return model.boolVar(true);
                }
                if (var.isInstantiatedTo(1)) {
                    return model.boolVar(true);
                }
                lits.put(var, children[i]);
            }
            ILogical[] ts = lits.values().toArray(new ILogical[0]);
            return LogOp.or(ts);
        }
        if (!n.hasOrChild()) {
            HashMap<BoolVar, ILogical> lits = new HashMap<BoolVar, ILogical>();
            for (int i = 0; i < children.length; ++i) {
                BoolVar var = LogicTreeToolBox.extract(children[i])[0];
                BoolVar boolVar = var = var.isNot() ? var.not() : var;
                if (lits.containsKey(var)) {
                    ILogical prev = (ILogical)lits.get(var);
                    if (prev.isNot() == children[i].isNot()) continue;
                    return model.boolVar(false);
                }
                if (var.isInstantiatedTo(0)) {
                    return model.boolVar(true);
                }
                lits.put(var, children[i]);
            }
            ILogical[] ts = lits.values().toArray(new ILogical[0]);
            return LogOp.and(ts);
        }
        for (int i = 0; i < children.length; ++i) {
            if (children[i].isLit()) continue;
            children[i] = LogicTreeToolBox.simplify(children[i], model);
        }
        return t;
    }

    public static ILogical simplifySingleton(ILogical l, Model model) {
        if (l.isLit()) {
            return l;
        }
        LogOp t = (LogOp)l;
        ILogical[] children = t.getChildren();
        ArrayList<ILogical> toRemove = new ArrayList<ILogical>();
        for (int i = 0; i < children.length; ++i) {
            if (!model.boolVar(true).equals(children[i])) continue;
            toRemove.add(children[i]);
        }
        toRemove.forEach(t::removeChild);
        if (t.getNbChildren() == 1) {
            return t.getChildren()[0];
        }
        return t;
    }

    private static ILogical orderAndReduce(ILogical t) {
        int i;
        if (t.isLit()) {
            return t;
        }
        LogOp n = (LogOp)t;
        ILogical[] children = n.getChildren();
        for (i = 0; i < children.length; ++i) {
            if (children[i].isLit()) continue;
            Arrays.sort(((LogOp)children[i]).getChildren(), LogicTreeToolBox::sameLogical);
        }
        Arrays.sort(children, LogicTreeToolBox::sameLogical);
        i = 0;
        int k = children.length - 1;
        while (i < k) {
            if (LogicTreeToolBox.sameLogical(children[i], children[i + 1]) == 0) {
                System.arraycopy(children, i + 1, children, i, children.length - i - 1);
                --k;
                continue;
            }
            ++i;
        }
        if (k == 0) {
            return children[0];
        }
        return new LogOp(n.operator, n.type, Arrays.copyOf(children, k + 1));
    }

    private static void sort(LogOp logOp) {
        Arrays.sort(logOp.getChildren(), (o1, o2) -> {
            if (o1.isNot() == o2.isNot()) {
                return 0;
            }
            if (o2.isNot()) {
                return -1;
            }
            return 1;
        });
    }

    private static int sameLogical(ILogical o1, ILogical o2) {
        if (o1.isLit()) {
            if (o2.isLit()) {
                return LogicTreeToolBox.sameLit(o1, o2);
            }
            return -1;
        }
        if (o2.isLit()) {
            return 1;
        }
        LogOp l1 = (LogOp)o1;
        LogOp l2 = (LogOp)o2;
        return LogicTreeToolBox.sameChild(l1, l2);
    }

    private static int sameLit(ILogical o1, ILogical o2) {
        int diff = ((BoolVar)o1).getId() - ((BoolVar)o2).getId();
        if (diff == 0) {
            if (o1.isNot() == o2.isNot()) {
                return 0;
            }
            if (o2.isNot()) {
                return -1;
            }
            return 1;
        }
        return diff;
    }

    private static int sameChild(LogOp l1, LogOp l2) {
        if (l1.getNbChildren() == l2.getNbChildren()) {
            int same = 0;
            for (int i = 0; i < l1.getNbChildren() && same == 0; ++i) {
                ILogical ll1 = l1.getChildren()[i];
                ILogical ll2 = l2.getChildren()[i];
                assert (ll1.isLit());
                assert (ll2.isLit());
                same = LogicTreeToolBox.sameLit(ll1, ll2);
            }
            return same;
        }
        return l1.getNbChildren() - l2.getNbChildren();
    }
}

