/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.List;
import org.knowm.xchart.HeatMapChart;
import org.knowm.xchart.HeatMapSeries;
import org.knowm.xchart.internal.Utils;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.PlotContent_;
import org.knowm.xchart.style.HeatMapStyler;
import org.knowm.xchart.style.Styler;

public class PlotContent_HeatMap<ST extends HeatMapStyler, S extends HeatMapSeries>
extends PlotContent_<ST, S> {
    private final ST heatMapStyler;
    private final DecimalFormat df = new DecimalFormat("");

    PlotContent_HeatMap(Chart<ST, S> chart) {
        super(chart);
        this.heatMapStyler = (HeatMapStyler)chart.getStyler();
    }

    @Override
    protected void doPaint(Graphics2D g) {
        double xTickSpace = ((Styler)this.heatMapStyler).getPlotContentSize() * this.getBounds().getWidth();
        double xLeftMargin = Utils.getTickStartOffset((int)this.getBounds().getWidth(), xTickSpace);
        double yTickSpace = ((Styler)this.heatMapStyler).getPlotContentSize() * this.getBounds().getHeight();
        double yTopMargin = Utils.getTickStartOffset((int)this.getBounds().getHeight(), yTickSpace);
        if (((HeatMapStyler)this.heatMapStyler).getHeatMapValueDecimalPattern() != null) {
            this.df.applyPattern(((HeatMapStyler)this.heatMapStyler).getHeatMapValueDecimalPattern());
        }
        Rectangle2D plotContentBounds = this.getBounds();
        HeatMapSeries series = ((HeatMapChart)this.chart).getHeatMapSeries();
        if (!series.isEnabled()) {
            return;
        }
        int x = 0;
        int y = 0;
        Double value = 0.0;
        List list = (List)series.getHeatData();
        List xData = (List)series.getXData();
        List yData = (List)series.getYData();
        double plotContentBoundsWidth = plotContentBounds.getWidth();
        double plotContentBoundsHeight = plotContentBounds.getHeight();
        double rectWidth = (plotContentBoundsWidth - 2.0 * xLeftMargin) / (double)xData.size();
        double rectHeight = (plotContentBoundsHeight - 2.0 * yTopMargin) / (double)yData.size();
        double xOffset = 0.0;
        double yOffset = 0.0;
        Rectangle2D.Double rect = null;
        Color heatMapValueColor = null;
        for (Number[] numbers : list) {
            if (numbers == null) continue;
            x = numbers[0].intValue();
            y = numbers[1].intValue();
            value = numbers[2].doubleValue();
            if (x >= xData.size() || y >= yData.size()) continue;
            xOffset = this.getBounds().getX() + xLeftMargin + rectWidth * (double)x;
            yOffset = this.getBounds().getY() + yTopMargin + rectHeight * (double)(yData.size() - 1 - y);
            rect = new Rectangle2D.Double(xOffset, yOffset, rectWidth, rectHeight);
            heatMapValueColor = this.getColor(series, value);
            g.setColor(heatMapValueColor);
            g.fill(rect);
            if (((HeatMapStyler)this.heatMapStyler).isDrawBorder()) {
                g.setColor(heatMapValueColor);
                g.setStroke(SOLID_STROKE);
                g.draw(rect);
            }
            if (((HeatMapStyler)this.heatMapStyler).isShowValue()) {
                this.showValue(g, rect, this.df.format(numbers[2]));
            }
            if (!((Styler)this.heatMapStyler).isToolTipsEnabled()) continue;
            this.toolTips.addData(rect, rect.getCenterX(), rect.getCenterY() + (double)((Styler)this.heatMapStyler).getToolTipFont().getSize(), 0.0, series.getName() + ": " + this.chart.getXAxisFormat().format(xData.get(x)) + ", " + this.chart.getYAxisFormat().format(yData.get(y)) + ", " + this.df.format(numbers[2]));
        }
    }

    private Color getColor(HeatMapSeries series, double value) {
        Color color = null;
        Color[] rangeColors = ((HeatMapStyler)this.chart.getStyler()).getRangeColors();
        double min = series.getMin();
        double max = series.getMax();
        if (value <= min) {
            color = rangeColors[0];
        } else if (value >= max) {
            color = rangeColors[rangeColors.length - 1];
        } else {
            double valueRation = (value - min) / (max - min);
            color = ((HeatMapStyler)this.heatMapStyler).isPiecewise() ? this.getPiecewiseColor(rangeColors, valueRation) : this.getGradientColor(rangeColors, valueRation);
        }
        return color;
    }

    private Color getPiecewiseColor(Color[] rangeColors, double valueRation) {
        Color color = null;
        int splitNumber = ((HeatMapStyler)this.chart.getStyler()).getSplitNumber();
        int splitNumberIndex = (int)(valueRation * (double)splitNumber);
        for (int i = 0; i < splitNumber; ++i) {
            if (splitNumberIndex == 0) {
                color = rangeColors[0];
                break;
            }
            if (splitNumberIndex == splitNumber - 1) {
                color = rangeColors[rangeColors.length - 1];
                break;
            }
            double index = (double)i / (double)splitNumber * (double)rangeColors.length;
            int beginColorIndex = (int)index;
            int endColorIndex = 0;
            endColorIndex = rangeColors.length != 1 ? beginColorIndex + 1 : beginColorIndex;
            if (splitNumberIndex != i) continue;
            Color beginColor = rangeColors[beginColorIndex];
            Color endColor = rangeColors[endColorIndex];
            int red = (int)((double)beginColor.getRed() + (index - (double)((int)index)) * (double)(endColor.getRed() - beginColor.getRed()));
            int green = (int)((double)beginColor.getGreen() + (index - (double)((int)index)) * (double)(endColor.getGreen() - beginColor.getGreen()));
            int blue = (int)((double)beginColor.getBlue() + (index - (double)((int)index)) * (double)(endColor.getBlue() - beginColor.getBlue()));
            color = new Color(red, green, blue);
            break;
        }
        return color;
    }

    private Color getGradientColor(Color[] rangeColors, double valueRation) {
        double index = valueRation * (double)(rangeColors.length - 1);
        Color color = null;
        int beginColorIndex = (int)index;
        int endColorIndex = 0;
        endColorIndex = rangeColors.length != 1 ? beginColorIndex + 1 : beginColorIndex;
        Color beginColor = rangeColors[beginColorIndex];
        Color endColor = rangeColors[endColorIndex];
        if ((int)index < rangeColors.length - 1) {
            int red = (int)((double)beginColor.getRed() + (index - (double)((int)index)) * (double)(endColor.getRed() - beginColor.getRed()));
            int green = (int)((double)beginColor.getGreen() + (index - (double)((int)index)) * (double)(endColor.getGreen() - beginColor.getGreen()));
            int blue = (int)((double)beginColor.getBlue() + (index - (double)((int)index)) * (double)(endColor.getBlue() - beginColor.getBlue()));
            color = new Color(red, green, blue);
        } else {
            color = endColor;
        }
        return color;
    }

    private void showValue(Graphics2D g, Rectangle2D rect, String value) {
        double rectCenterX = rect.getCenterX();
        double rectCenterY = rect.getCenterY();
        TextLayout textLayout = new TextLayout(value, ((HeatMapStyler)this.heatMapStyler).getValueFont(), new FontRenderContext(null, true, false));
        Rectangle2D annotationRectangle = textLayout.getBounds();
        g.setColor(((HeatMapStyler)this.heatMapStyler).getValueFontColor());
        AffineTransform orig = g.getTransform();
        AffineTransform at = new AffineTransform();
        at.translate(rectCenterX - annotationRectangle.getWidth() / 2.0, rectCenterY + annotationRectangle.getHeight() / 2.0);
        g.transform(at);
        g.fill(textLayout.getOutline(null));
        g.setTransform(orig);
    }
}

