# Define the generic function
filter_first_three_rows <- function(data, ...) {
  UseMethod("filter_first_three_rows")
}

#' Filter the first three rows of column y for dataframe_with_y class
#'
#' @param data A dataframe of class dataframe_with_y
#' @return A dataframe with filtered values
#' @export
#' @importFrom magrittr %>%
#' @examples
#' \dontrun{
#' library(dplyr)
#' library(magrittr)
#'
#' df <- data.frame(x = 1:4, y = 1:4)
#' class(df) <- "dataframe_with_y"
#'
#' filtered_y <- filter_first_three_rows(df)
#' print(filtered_y)
#' }
filter_first_three_rows.dataframe_with_y <- function(data) {
  library(dplyr)
  y <- NULL
  class(data) <- "data.frame"  # Remove the custom class
  dplyr::filter(data, row_number() <= 3) %>% select(y)
}

#' Filter the first three rows of column y for list class
#'
#' @param data A list containing a dataframe
#' @param ... Additional arguments (not used)
#' @return A dataframe with filtered values
#' @export
#' @examples
#' \dontrun{
#' library(dplyr)
#' library(magrittr)
#'
#' df <- data.frame(x = 1:4, y = 1:4)
#' class(df) <- "dataframe_with_y"
#' data_list <- list(df)
#'
#' filtered_y_list <- filter_first_three_rows(data_list)
#' print(filtered_y_list)
#' }
filter_first_three_rows.list <- function(data, ...) {
  filtered_list <- lapply(data, function(element) {
    if (is.data.frame(element) && "y" %in% colnames(element)) {
      y <- NULL
      class(element) <- "data.frame"  # Remove any custom class
      dplyr::filter(element, row_number() <= 3) %>% select(y)
    } else {
      element  # Return the element unchanged if it's not a dataframe with column 'y'
    }
  })

  return(filtered_list)
}
