/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regarima.estimation;

import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.arima.estimation.IArimaMapping;
import jdplus.toolkit.base.core.math.functions.IParametersDomain;
import jdplus.toolkit.base.core.math.functions.IParametricMapping;
import jdplus.toolkit.base.core.math.functions.ssq.ISsqFunction;
import jdplus.toolkit.base.core.math.functions.ssq.ISsqFunctionPoint;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.regarima.RegArmaModel;
import jdplus.toolkit.base.core.regarima.estimation.ConcentratedLikelihoodComputer;
import jdplus.toolkit.base.core.stats.likelihood.ConcentratedLikelihoodWithMissing;
import jdplus.toolkit.base.core.stats.likelihood.DefaultLikelihoodEvaluation;
import jdplus.toolkit.base.core.stats.likelihood.Likelihood;

class RegArmaSsqFunction<S extends IArimaModel>
implements ISsqFunction {
    final DoubleSeq dy;
    final FastMatrix x;
    final int nmissing;
    final IParametricMapping<S> mapping;
    final ConcentratedLikelihoodComputer cll;
    final ToDoubleFunction<Likelihood> ssqll;
    final Function<Likelihood, DoubleSeq> errors;
    final boolean mt;

    public static <S extends IArimaModel> SsqBuilder<S> builder(DoubleSeq y) {
        return new SsqBuilder(y);
    }

    private RegArmaSsqFunction(DoubleSeq dy, FastMatrix x, int nm, IParametricMapping<S> mapping, ConcentratedLikelihoodComputer cll, Function<Likelihood, DoubleSeq> errors, ToDoubleFunction<Likelihood> ssqll, boolean mt) {
        this.dy = dy;
        this.x = x;
        this.nmissing = nm;
        this.mapping = mapping;
        this.cll = cll;
        this.ssqll = ssqll;
        this.errors = errors;
        this.mt = mt;
    }

    @Override
    public IParametersDomain getDomain() {
        return this.mapping;
    }

    @Override
    public Evaluation<S> ssqEvaluate(DoubleSeq parameters) {
        return new Evaluation(this, parameters);
    }

    static class SsqBuilder<S extends IArimaModel> {
        private ConcentratedLikelihoodComputer cll = ConcentratedLikelihoodComputer.DEFAULT_FULL_COMPUTER;
        private ToDoubleFunction<Likelihood> eval = DefaultLikelihoodEvaluation.deviance();
        private Function<Likelihood, DoubleSeq> errors = DefaultLikelihoodEvaluation.v();
        private boolean mt = false;
        private final DoubleSeq dy;
        private FastMatrix x;
        private int nmissing;
        private IArimaMapping<S> mapping;

        private SsqBuilder(DoubleSeq dy) {
            this.dy = dy;
        }

        SsqBuilder variables(FastMatrix x) {
            this.x = x;
            return this;
        }

        SsqBuilder missingCount(int nm) {
            this.nmissing = nm;
            return this;
        }

        SsqBuilder mapping(IArimaMapping<S> mapping) {
            this.mapping = mapping;
            return this;
        }

        SsqBuilder parallelProcessing(boolean parallel) {
            this.mt = parallel;
            return this;
        }

        SsqBuilder maximumLikelihood(boolean ml) {
            if (ml) {
                this.eval = DefaultLikelihoodEvaluation.deviance();
                this.errors = DefaultLikelihoodEvaluation.v();
            } else {
                this.eval = DefaultLikelihoodEvaluation.ssq();
                this.errors = DefaultLikelihoodEvaluation.errors();
            }
            return this;
        }

        SsqBuilder likelihoodEvaluation(ToDoubleFunction<Likelihood> eval) {
            this.eval = eval;
            return this;
        }

        SsqBuilder errors(Function<Likelihood, DoubleSeq> errors) {
            this.errors = errors;
            return this;
        }

        SsqBuilder likelihoodComputer(ConcentratedLikelihoodComputer computer) {
            this.cll = computer;
            return this;
        }

        public RegArmaSsqFunction<S> build() {
            return new RegArmaSsqFunction<S>(this.dy, this.x, this.nmissing, this.mapping, this.cll, this.errors, this.eval, this.mt);
        }
    }

    static class Evaluation<S extends IArimaModel>
    implements ISsqFunctionPoint {
        final RegArmaSsqFunction<S> fn;
        final DoubleSeq p;
        final S arma;
        final ConcentratedLikelihoodWithMissing ll;

        public Evaluation(RegArmaSsqFunction<S> fn, DoubleSeq p) {
            this.fn = fn;
            this.p = p;
            this.arma = (IArimaModel)fn.mapping.map(p);
            RegArmaModel<S> regarma = new RegArmaModel<S>(fn.dy, this.arma, fn.nmissing, fn.x);
            this.ll = fn.cll.compute(regarma);
        }

        @Override
        public DoubleSeq getE() {
            return this.fn.errors.apply(this.ll);
        }

        @Override
        public DoubleSeq getParameters() {
            return this.p;
        }

        @Override
        public double getSsqE() {
            return this.fn.ssqll.applyAsDouble(this.ll);
        }

        @Override
        public ISsqFunction getSsqFunction() {
            return this.fn;
        }

        public DoubleSeq allCoefficients() {
            return this.ll.allCoefficients();
        }
    }
}

