/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchratemodel;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.util.Taxon;
import dr.evomodel.branchratemodel.AbstractBranchRateModel;
import dr.evomodel.branchratemodel.ArbitraryBranchRates;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.branchratemodel.DifferentiableBranchRates;
import dr.evomodel.branchratemodel.NodeRateMap;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.util.Citable;
import dr.util.Citation;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;
import java.util.List;
import java.util.function.DoubleBinaryOperator;

public class TimeIncrementBranchRateModel
extends AbstractBranchRateModel
implements DifferentiableBranchRates,
Citable {
    private static final String PARSER_NAME = "timeIncrementBranchRateModel";
    private static final String INCREMENT = "increment";
    private final TreeModel treeModel;
    private final BranchRateModel branchRateModel;
    private final DifferentiableBranchRates differentiableBranchRateModel;
    private final NodeRef tip;
    private final Parameter offset;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(AbstractBranchRateModel.class), new ElementRule(Taxon.class), new ElementRule(Parameter.class)};

        @Override
        public String getParserName() {
            return TimeIncrementBranchRateModel.PARSER_NAME;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            TreeModel treeModel = (TreeModel)xMLObject.getChild(TreeModel.class);
            BranchRateModel branchRateModel = (BranchRateModel)xMLObject.getChild(AbstractBranchRateModel.class);
            Taxon taxon = (Taxon)xMLObject.getChild(Taxon.class);
            Parameter parameter = (Parameter)xMLObject.getChild(Parameter.class);
            return new TimeIncrementBranchRateModel("name", treeModel, branchRateModel, taxon, parameter);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return "TODO";
        }

        @Override
        public Class getReturnType() {
            return TimeIncrementBranchRateModel.class;
        }
    };

    public TimeIncrementBranchRateModel(String string, TreeModel treeModel, BranchRateModel branchRateModel, Taxon taxon, Parameter parameter) {
        super(string);
        this.treeModel = treeModel;
        this.branchRateModel = branchRateModel;
        this.differentiableBranchRateModel = branchRateModel instanceof DifferentiableBranchRates ? (DifferentiableBranchRates)((Object)branchRateModel) : null;
        this.tip = treeModel.getNode(treeModel.getTaxonIndex(taxon));
        if (this.tip == null) {
            throw new IllegalArgumentException("Unable to find tip node for taxon");
        }
        this.offset = parameter;
        this.addModel(treeModel);
        this.addModel(branchRateModel);
        this.addVariable(parameter);
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
        this.fireModelChanged();
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.fireModelChanged();
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public double getBranchRateDifferential(Tree tree, NodeRef nodeRef) {
        this.checkDifferentiability();
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double getBranchRateSecondDifferential(Tree tree, NodeRef nodeRef) {
        this.checkDifferentiability();
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public Parameter getRateParameter() {
        this.checkDifferentiability();
        return this.differentiableBranchRateModel.getRateParameter();
    }

    @Override
    public Tree getTree() {
        return this.treeModel;
    }

    @Override
    public int getParameterIndexFromNode(NodeRef nodeRef) {
        this.checkDifferentiability();
        return this.differentiableBranchRateModel.getParameterIndexFromNode(nodeRef);
    }

    private void checkDifferentiability() {
        if (this.differentiableBranchRateModel == null) {
            throw new RuntimeException("Non-differentiable base BranchRateModel");
        }
    }

    @Override
    public ArbitraryBranchRates.BranchRateTransform getTransform() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double[] updateGradientLogDensity(double[] dArray, double[] dArray2, int n, int n2) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double[] updateDiagonalHessianLogDensity(double[] dArray, double[] dArray2, double[] dArray3, int n, int n2) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double mapReduceOverRates(NodeRateMap nodeRateMap, DoubleBinaryOperator doubleBinaryOperator, double d) {
        this.checkDifferentiability();
        return this.differentiableBranchRateModel.mapReduceOverRates(nodeRateMap, doubleBinaryOperator, d);
    }

    @Override
    public void forEachOverRates(NodeRateMap nodeRateMap) {
        this.checkDifferentiability();
        this.differentiableBranchRateModel.forEachOverRates(nodeRateMap);
    }

    @Override
    public double getBranchRate(Tree tree, NodeRef nodeRef) {
        double d = this.branchRateModel.getBranchRate(tree, nodeRef);
        if (nodeRef == this.tip) {
            double d2 = tree.getBranchLength(nodeRef);
            double d3 = d2 + this.offset.getParameterValue(0);
            d *= d3 / d2;
        }
        return d;
    }

    @Override
    public double getUntransformedBranchRate(Tree tree, NodeRef nodeRef) {
        this.checkDifferentiability();
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.MOLECULAR_CLOCK;
    }

    @Override
    public String getDescription() {
        String string = this.branchRateModel instanceof Citable ? ((Citable)((Object)this.branchRateModel)).getDescription() : "Unknown clock model";
        string = string + " with lost time for taxon " + this.tip;
        return string;
    }

    @Override
    public List<Citation> getCitations() {
        ArrayList<Citation> arrayList = this.branchRateModel instanceof Citable ? new ArrayList<Citation>(((Citable)((Object)this.branchRateModel)).getCitations()) : new ArrayList();
        return arrayList;
    }
}

