/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.evomodel.operators.AbstractTreeOperator;
import dr.inference.operators.AdaptableMCMCOperator;
import dr.inference.operators.AdaptationMode;

public abstract class AbstractAdaptableTreeOperator
extends AbstractTreeOperator
implements AdaptableMCMCOperator {
    public final AdaptationMode mode;
    private final double targetAcceptanceProbability;
    private long adaptationCount = 0L;

    public AbstractAdaptableTreeOperator(AdaptationMode adaptationMode) {
        this(adaptationMode, 0.234);
    }

    public AbstractAdaptableTreeOperator(AdaptationMode adaptationMode, double d) {
        this.mode = adaptationMode;
        this.targetAcceptanceProbability = System.getProperty("mcmc.adaptation_target") != null ? Double.parseDouble(System.getProperty("mcmc.adaptation_target")) : d;
    }

    @Override
    public void setAdaptableParameter(double d) {
        ++this.adaptationCount;
        this.setAdaptableParameterValue(d);
    }

    @Override
    public double getAdaptableParameter() {
        return this.getAdaptableParameterValue();
    }

    @Override
    public long getAdaptationCount() {
        return this.adaptationCount;
    }

    @Override
    public void setAdaptationCount(long l) {
        this.adaptationCount = l;
    }

    protected abstract void setAdaptableParameterValue(double var1);

    protected abstract double getAdaptableParameterValue();

    @Override
    public AdaptationMode getMode() {
        return this.mode;
    }

    @Override
    public double getMinimumAcceptanceLevel() {
        return 0.1;
    }

    @Override
    public double getMaximumAcceptanceLevel() {
        return 0.4;
    }

    @Override
    public double getMinimumGoodAcceptanceLevel() {
        return 0.2;
    }

    @Override
    public double getMaximumGoodAcceptanceLevel() {
        return 0.3;
    }

    @Override
    public final String getPerformanceSuggestion() {
        return null;
    }

    @Override
    public double getTargetAcceptanceProbability() {
        return this.targetAcceptanceProbability;
    }
}

