/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.align.scores;

import jebl.evolution.align.scores.AminoAcidScores;
import jebl.evolution.align.scores.NucleotideScores;
import jebl.evolution.align.scores.ScoreMatrix;

public abstract class Scores
implements ScoreMatrix {
    public float[][] score;
    private String extraResidues = "";

    protected void buildScores(float[][] scores) {
        String states = this.getAlphabet().toUpperCase();
        this.score = new float[127][127];
        for (int i = 0; i < states.length(); ++i) {
            char a = states.charAt(i);
            char lca = Character.toLowerCase(a);
            for (int j = 0; j <= i; ++j) {
                char b = states.charAt(j);
                char lcb = Character.toLowerCase(b);
                float f = scores[i][j];
                this.score[lcb][lca] = f;
                this.score[lca][lcb] = f;
                this.score[b][lca] = f;
                this.score[lca][b] = f;
                this.score[lcb][a] = f;
                this.score[a][lcb] = f;
                this.score[b][a] = f;
                this.score[a][b] = f;
            }
        }
    }

    void buildScores(float match, float mismatch) {
        int states = this.getAlphabet().length();
        float[][] scores = new float[states][states];
        for (int i = 0; i < states; ++i) {
            for (int j = 0; j < states; ++j) {
                scores[i][j] = i == j ? match : mismatch;
            }
        }
        this.buildScores(scores);
    }

    public final float getScore(char x, char y) {
        return this.score[x][y];
    }

    public String toString() {
        String name = this.getClass().getName();
        return name.substring(name.lastIndexOf(".") + 1);
    }

    public static Scores forMatrix(ScoreMatrix scoreMatrix) {
        final String alphabet = scoreMatrix.getAlphabet();
        final String name = scoreMatrix.getName();
        float[][] scores = new float[alphabet.length()][alphabet.length()];
        for (int i = 0; i < alphabet.length(); ++i) {
            char a = alphabet.charAt(i);
            for (int j = 0; j < alphabet.length(); ++j) {
                char b = alphabet.charAt(j);
                scores[i][j] = scoreMatrix.getScore(a, b);
            }
        }
        Scores result = new Scores(){

            public String getAlphabet() {
                return alphabet;
            }

            public String getName() {
                return name;
            }
        };
        result.buildScores(scores);
        return result;
    }

    public static Scores duplicate(Scores scores) {
        Scores result;
        if (scores instanceof AminoAcidScores) {
            result = new AminoAcidScores();
        } else if (scores instanceof NucleotideScores) {
            result = new NucleotideScores((NucleotideScores)scores);
        } else {
            final String alphabet = scores.getAlphabet();
            final String name = scores.getName();
            result = new Scores(){

                public String getAlphabet() {
                    return alphabet + this.getExtraResidues();
                }

                public String getName() {
                    return name;
                }
            };
        }
        result.extraResidues = scores.getExtraResidues();
        result.score = new float[127][127];
        for (int i = 0; i < 127; ++i) {
            System.arraycopy(scores.score[i], 0, result.score[i], 0, 127);
        }
        return result;
    }

    public static Scores includeGaps(Scores scores, float gapVersusResidueCost, float gapVersusGapCost) {
        Scores result = Scores.duplicate(scores);
        String states = scores.getAlphabet();
        for (int i = 0; i < states.length(); ++i) {
            char res1 = states.charAt(i);
            result.score[45][res1] = gapVersusResidueCost;
            result.score[res1][45] = gapVersusResidueCost;
        }
        result.score[45][45] = gapVersusGapCost;
        return result;
    }

    public static Scores includeAdditionalCharacters(Scores scores, String characters) {
        Scores result = Scores.duplicate(scores);
        String states = scores.getAlphabet();
        char[] unique = new char[characters.length()];
        int index = 0;
        for (char character : characters.toCharArray()) {
            if (states.indexOf(character) >= 0) continue;
            unique[index++] = character;
        }
        result.extraResidues = result.extraResidues + new String(unique, 0, index);
        return result;
    }

    protected String getExtraResidues() {
        return this.extraResidues;
    }

    public String getMatrixString() {
        String alphabet = this.getAlphabet();
        StringBuilder builder = new StringBuilder();
        builder.append("  ");
        for (char c1 : alphabet.toCharArray()) {
            builder.append("  ").append(c1).append("   ");
        }
        builder.append("\n");
        for (char c : alphabet.toCharArray()) {
            builder.append(c).append(" ");
            for (char c1 : alphabet.toCharArray()) {
                float s = this.score[c][c1];
                builder.append(String.format("%+1.2f ", Float.valueOf(s)));
            }
            builder.append("\n");
        }
        return builder.toString();
    }
}

