## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.path = "figures/sobol-stochastic-",
  fig.width = 7,
  fig.height = 5,
  dpi = 150,
  message = FALSE,
  warning = FALSE,
  eval=FALSE
)

LOCAL <- identical(Sys.getenv("LOCAL"), "TRUE")

library(Sobol4R)
library(sensitivity)
set.seed(4669)

## -----------------------------------------------------------------------------
# sobol_indices(
#   model      = ishigami_model,
#   design     = sobol_design(n = 512, d = 3, quasi = TRUE),
#   estimator  = "jansen",  # default
#   replicates = 1L
# )

