/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators;

import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import javax.vecmath.Point2d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Vector2d;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.color.CDK2DAtomColors;
import org.openscience.cdk.renderer.color.IAtomColorer;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.TextElement;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.generators.IGeneratorParameter;
import org.openscience.cdk.renderer.generators.parameter.AbstractGeneratorParameter;

public class AtomNumberGenerator
implements IGenerator<IAtomContainer> {
    private final IGeneratorParameter<Color> textColor = new AtomNumberTextColor();
    private final WillDrawAtomNumbers willDrawAtomNumbers = new WillDrawAtomNumbers();
    private final IGeneratorParameter<IAtomColorer> atomColorer = new AtomColorer();
    private final IGeneratorParameter<Boolean> colorByType = new ColorByType();
    private final Offset offset = new Offset();

    public IRenderingElement generate(IAtomContainer container, RendererModel model) {
        ElementGroup numbers = new ElementGroup();
        if (!((Boolean)((WillDrawAtomNumbers)model.getParameter(WillDrawAtomNumbers.class)).getValue()).booleanValue()) {
            return numbers;
        }
        Vector2d offset = new Vector2d(((Vector2d)this.offset.getValue()).x, -((Vector2d)this.offset.getValue()).y);
        offset.scale(1.0 / (Double)((BasicSceneGenerator.Scale)model.getParameter(BasicSceneGenerator.Scale.class)).getValue());
        int number = 1;
        for (IAtom atom : container.atoms()) {
            Point2d point = new Point2d(atom.getPoint2d());
            point.add((Tuple2d)offset);
            numbers.add((IRenderingElement)new TextElement(point.x, point.y, String.valueOf(number), (Boolean)this.colorByType.getValue() != false ? ((IAtomColorer)this.atomColorer.getValue()).getAtomColor(atom) : (Color)this.textColor.getValue()));
            ++number;
        }
        return numbers;
    }

    public List<IGeneratorParameter<?>> getParameters() {
        return Arrays.asList(new IGeneratorParameter[]{this.textColor, this.willDrawAtomNumbers, this.offset, this.atomColorer, this.colorByType});
    }

    public static class Offset
    extends AbstractGeneratorParameter<Vector2d> {
        public Vector2d getDefault() {
            return new Vector2d();
        }
    }

    public static class ColorByType
    extends AbstractGeneratorParameter<Boolean> {
        public Boolean getDefault() {
            return Boolean.FALSE;
        }
    }

    public static class AtomColorer
    extends AbstractGeneratorParameter<IAtomColorer> {
        public IAtomColorer getDefault() {
            return new CDK2DAtomColors();
        }
    }

    public static class WillDrawAtomNumbers
    extends AbstractGeneratorParameter<Boolean> {
        public Boolean getDefault() {
            return Boolean.TRUE;
        }
    }

    public static class AtomNumberTextColor
    extends AbstractGeneratorParameter<Color> {
        public Color getDefault() {
            return Color.BLACK;
        }
    }
}

