### Measurement procedures

In addition to describing the behavior you plan to measure and the study design that you intend to use, you will need to specify how you plan to measure the behavior that occurs during each session. You may find it useful to experiment and try out several different scenarios here. For each scenario, you will need to input the following pieces of information:

* Specify the __session length__ (in minutes) in the first input box of column three. 
* Specify the __measurement system__ in the second input box of column three. For event behaviors, the available measurement systems are frequency counting and partial interval recording. For state behaviors, the available measurement systems are continuous recording, momentary time sampling, partial interval recording, and whole interval recording_. See below for further details. 
* For the interval-based measurement systems, you will also need to specify the __interval length__ (in seconds) in the third input box of column three. The default value is 15 seconds. 

#### Measurement systems for event behaviors

If you will be measuring an event behavior, you will need to use either frequency counting or partial interval recording.

* __Frequency counting__ involves counting the total number of times that the behavior occurs over the course of the session. 
* __Partial interval recording__ involves dividing up the session time into short intervals, then scoring each interval for the presence or absence of the behavior. For a given interval, the behavior is scored as present if it occurs at any point during the interval, regardless of the number of times that it occurs, and is otherwise scored as absent. The overall score for the session is then taken to be the percentage of intervals where the behavior was present. Note that this system will tend to under-represent the actual frequency of the behavior. 

#### Measurement systems for state behaviors

If you will be measuring a state behavior, you might use any of several different measurement systems. __Continuous recording__ involves measuring the overall amount of time that the behavior occurs during the course of the session, and is typically reported as a percentage of total session time. Continuous recording is sometimes implemented by recording the time at which each episode of behavior starts and stops, often with the aide of a computer recording system. 

The other measurement systems for state behavior are all __interval-based__, in that they each involve dividing up the session time into short intervals. Each interval is scored for the presence or absence of the behavior, with each system using a different scoring rule. The overall score for the session is then taken to be the percentage of intervals where the behavior was present.

* In __momentary time sampling__, the behavior is scored as present if it is occurring during the last moment of the interval (and is otherwise scored as absent). Even though it is an interval-based system, momentary time sampling produces an __unbiased estimate__ of the overall percentage of time that the behavior occurs.
* In __partial interval recording__, the behavior is scored as present if it occurs at any point during the interval, regardless of how long it occurs (and is otherwise scored as absent). Partial interval recording will tend to produce __over-estimates__ of the true percentage occurrence.
* In __whole interval recording__, the behavior is scored as present only if it occurs for the entire duration of the interval (and is otherwise scored as absent). Whole interval recording will tend to produce __under-estimates__ of the true percentage occurrence. 
