/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.internal;

import com.simba.athena.amazonaws.AbortedException;
import com.simba.athena.amazonaws.internal.MetricAware;
import com.simba.athena.amazonaws.internal.Releasable;
import com.simba.athena.amazonaws.util.IOUtils;
import com.simba.athena.amazonaws.util.SdkRuntime;
import com.simba.athena.shaded.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.io.InputStream;

public abstract class SdkInputStream
extends InputStream
implements MetricAware,
Releasable {
    protected abstract InputStream getWrappedInputStream();

    @Override
    public final boolean isMetricActivated() {
        InputStream in = this.getWrappedInputStream();
        if (in instanceof MetricAware) {
            MetricAware metricAware = (MetricAware)((Object)in);
            return metricAware.isMetricActivated();
        }
        return false;
    }

    protected final void abortIfNeeded() {
        if (SdkRuntime.shouldAbort()) {
            try {
                this.abort();
            }
            catch (IOException e) {
                LogFactory.getLog(this.getClass()).debug("FYI", e);
            }
            throw new AbortedException();
        }
    }

    protected void abort() throws IOException {
    }

    @Override
    public void release() {
        IOUtils.closeQuietly(this, null);
        InputStream in = this.getWrappedInputStream();
        if (in instanceof Releasable) {
            Releasable r = (Releasable)((Object)in);
            r.release();
        }
    }
}

