/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.athenastreamingservice;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.simba.athena.amazonaws.AmazonServiceException;
import com.simba.athena.amazonaws.AmazonWebServiceClient;
import com.simba.athena.amazonaws.AmazonWebServiceRequest;
import com.simba.athena.amazonaws.AmazonWebServiceResponse;
import com.simba.athena.amazonaws.ClientConfiguration;
import com.simba.athena.amazonaws.ClientConfigurationFactory;
import com.simba.athena.amazonaws.Request;
import com.simba.athena.amazonaws.Response;
import com.simba.athena.amazonaws.ResponseMetadata;
import com.simba.athena.amazonaws.annotation.SdkInternalApi;
import com.simba.athena.amazonaws.annotation.ThreadSafe;
import com.simba.athena.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.simba.athena.amazonaws.client.AwsSyncClientParams;
import com.simba.athena.amazonaws.client.builder.AdvancedConfig;
import com.simba.athena.amazonaws.handlers.HandlerChainFactory;
import com.simba.athena.amazonaws.handlers.HandlerContextKey;
import com.simba.athena.amazonaws.http.ExecutionContext;
import com.simba.athena.amazonaws.http.HttpResponseHandler;
import com.simba.athena.amazonaws.internal.StaticCredentialsProvider;
import com.simba.athena.amazonaws.metrics.RequestMetricCollector;
import com.simba.athena.amazonaws.protocol.json.JsonClientMetadata;
import com.simba.athena.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.simba.athena.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.simba.athena.amazonaws.protocol.json.JsonOperationMetadata;
import com.simba.athena.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.simba.athena.amazonaws.services.athenastreamingservice.AthenaStreamingService;
import com.simba.athena.amazonaws.services.athenastreamingservice.AthenaStreamingServiceClientBuilder;
import com.simba.athena.amazonaws.services.athenastreamingservice.model.AthenaStreamingServiceException;
import com.simba.athena.amazonaws.services.athenastreamingservice.model.GetQueryResultsStreamRequest;
import com.simba.athena.amazonaws.services.athenastreamingservice.model.GetQueryResultsStreamResult;
import com.simba.athena.amazonaws.services.athenastreamingservice.model.InternalServerException;
import com.simba.athena.amazonaws.services.athenastreamingservice.model.InvalidRequestException;
import com.simba.athena.amazonaws.services.athenastreamingservice.model.TooManyRequestsException;
import com.simba.athena.amazonaws.services.athenastreamingservice.model.transform.GetQueryResultsStreamRequestProtocolMarshaller;
import com.simba.athena.amazonaws.services.athenastreamingservice.model.transform.GetQueryResultsStreamResultJsonUnmarshaller;
import com.simba.athena.amazonaws.util.AWSRequestMetrics;
import com.simba.athena.amazonaws.util.CredentialUtils;
import com.simba.athena.shaded.apache.commons.logging.Log;
import com.simba.athena.shaded.apache.commons.logging.LogFactory;
import java.net.URI;

@ThreadSafe
public class AthenaStreamingServiceClient
extends AmazonWebServiceClient
implements AthenaStreamingService {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AthenaStreamingService.class);
    private static final String DEFAULT_SIGNING_NAME = "athena";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyRequestsException").withModeledClass(TooManyRequestsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withModeledClass(InternalServerException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRequestException").withModeledClass(InvalidRequestException.class)).withBaseServiceExceptionClass(AthenaStreamingServiceException.class));

    @Deprecated
    public AthenaStreamingServiceClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public AthenaStreamingServiceClient(ClientConfiguration clientConfiguration) {
        this(DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public AthenaStreamingServiceClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AthenaStreamingServiceClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.advancedConfig = AdvancedConfig.EMPTY;
        this.init();
    }

    @Deprecated
    public AthenaStreamingServiceClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AthenaStreamingServiceClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AthenaStreamingServiceClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.advancedConfig = AdvancedConfig.EMPTY;
        this.init();
    }

    public static AthenaStreamingServiceClientBuilder builder() {
        return AthenaStreamingServiceClientBuilder.standard();
    }

    AthenaStreamingServiceClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AthenaStreamingServiceClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix("athenastreaming");
        this.setEndpoint("https://athena.us-east-1.amazonaws.com:444");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/simba/athena/amazonaws/services/athenastreamingservice/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/simba/athena/amazonaws/services/athenastreamingservice/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public GetQueryResultsStreamResult getQueryResultsStream(GetQueryResultsStreamRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetQueryResultsStream(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetQueryResultsStreamResult executeGetQueryResultsStream(GetQueryResultsStreamRequest getQueryResultsStreamRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getQueryResultsStreamRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetQueryResultsStreamRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetQueryResultsStreamRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getQueryResultsStreamRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "AthenaStreamingService");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetQueryResultsStream");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(false).withHasStreamingSuccessResponse(true), new GetQueryResultsStreamResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetQueryResultsStreamResult getQueryResultsStreamResult = (GetQueryResultsStreamResult)response.getAwsResponse();
            return getQueryResultsStreamResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

