/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.iamsupport.model;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSSessionCredentials;
import java.util.Date;

public class CredentialsHolder
implements AWSCredentials {
    protected AWSCredentials m_credentials;
    private Date m_expiration;
    private IamMetadata m_metadata;

    @Override
    public String getAWSAccessKeyId() {
        return this.m_credentials.getAWSAccessKeyId();
    }

    @Override
    public String getAWSSecretKey() {
        return this.m_credentials.getAWSSecretKey();
    }

    public Date getExpiration() {
        return this.m_expiration;
    }

    public String getSessionToken() {
        if (this.m_credentials instanceof AWSSessionCredentials) {
            return ((AWSSessionCredentials)this.m_credentials).getSessionToken();
        }
        return null;
    }

    public IamMetadata getMetadata() {
        if (this.m_metadata == null) {
            return null;
        }
        return this.m_metadata.clone();
    }

    public boolean isExpired() {
        return this.m_expiration != null && this.m_expiration.before(new Date());
    }

    public static CredentialsHolder newInstance(AWSCredentials aWSCredentials) {
        if (aWSCredentials instanceof AWSSessionCredentials) {
            return new SessionCredentialsHolder(aWSCredentials);
        }
        return new CredentialsHolder(aWSCredentials);
    }

    public static CredentialsHolder newInstance(AWSCredentials aWSCredentials, Date date) {
        if (aWSCredentials instanceof AWSSessionCredentials) {
            return new SessionCredentialsHolder(aWSCredentials, date);
        }
        return new CredentialsHolder(aWSCredentials, date);
    }

    public void setMetadata(IamMetadata iamMetadata) {
        this.m_metadata = iamMetadata;
    }

    protected CredentialsHolder(AWSCredentials aWSCredentials) {
        this(aWSCredentials, new Date(System.currentTimeMillis() + 900000L));
    }

    protected CredentialsHolder(AWSCredentials aWSCredentials, Date date) {
        this.m_credentials = aWSCredentials;
        if (aWSCredentials instanceof CredentialsHolder) {
            CredentialsHolder credentialsHolder = (CredentialsHolder)aWSCredentials;
            this.m_expiration = credentialsHolder.getExpiration();
        } else {
            this.m_expiration = date;
        }
    }

    public static final class IamMetadata
    implements Cloneable {
        private Boolean autoCreate;
        private String dbUser;
        private String dbGroups;

        public IamMetadata clone() {
            try {
                return (IamMetadata)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public Boolean getAutoCreate() {
            return this.autoCreate;
        }

        public String getDbGroups() {
            return this.dbGroups;
        }

        public String getDbUser() {
            return this.dbUser;
        }

        public void setAutoCreate(Boolean bl) {
            this.autoCreate = bl;
        }

        public void setDbGroups(String string) {
            this.dbGroups = string;
        }

        public void setDbUser(String string) {
            this.dbUser = string;
        }
    }

    private static final class SessionCredentialsHolder
    extends CredentialsHolder
    implements AWSSessionCredentials {
        @Override
        public String getSessionToken() {
            return ((AWSSessionCredentials)this.m_credentials).getSessionToken();
        }

        protected SessionCredentialsHolder(AWSCredentials aWSCredentials) {
            super(aWSCredentials);
        }

        protected SessionCredentialsHolder(AWSCredentials aWSCredentials, Date date) {
            super(aWSCredentials, date);
        }
    }
}

